/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jsondoclet;

import capital.scalable.restdocs.jsondoclet.DocletUtils;
import capital.scalable.restdocs.jsondoclet.FieldDocumentation;
import capital.scalable.restdocs.jsondoclet.MethodDocumentation;
import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.ParamTree;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import jdk.javadoc.doclet.DocletEnvironment;

public final class ClassDocumentation {
    private String comment = "";
    private final Map<String, FieldDocumentation> fields = new HashMap<String, FieldDocumentation>();
    private final Map<String, MethodDocumentation> methods = new HashMap<String, MethodDocumentation>();

    private ClassDocumentation() {
    }

    public static ClassDocumentation fromClassDoc(DocletEnvironment docEnv, Element element) {
        ClassDocumentation cd = new ClassDocumentation();
        cd.setComment(DocletUtils.cleanupDocComment(docEnv.getElementUtils().getDocComment(element)));
        if ("RECORD".equals(element.getKind().name())) {
            Optional.ofNullable(docEnv.getDocTrees().getDocCommentTree(element)).stream().map(DocCommentTree::getBlockTags).flatMap(Collection::stream).filter(ParamTree.class::isInstance).map(ParamTree.class::cast).filter(p -> !p.isTypeParameter()).forEach(p -> {
                String name = p.getName().getName().toString();
                String desc = p.getDescription().stream().map(Object::toString).collect(Collectors.joining(" "));
                cd.fields.put(name, FieldDocumentation.fromString(desc));
            });
        } else {
            element.getEnclosedElements().forEach(fieldOrMethod -> {
                switch (fieldOrMethod.getKind()) {
                    case FIELD: {
                        cd.addField(docEnv, (Element)fieldOrMethod);
                        break;
                    }
                    case METHOD: 
                    case CONSTRUCTOR: {
                        cd.addMethod(docEnv, (Element)fieldOrMethod);
                        break;
                    }
                }
            });
        }
        return cd;
    }

    private void setComment(String comment) {
        this.comment = comment;
    }

    private void addField(DocletEnvironment docEnv, Element element) {
        this.fields.put(element.getSimpleName().toString(), FieldDocumentation.fromFieldDoc(docEnv, element));
    }

    private void addMethod(DocletEnvironment docEnv, Element element) {
        this.methods.put(element.getSimpleName().toString(), MethodDocumentation.fromMethodDoc(docEnv, element));
    }
}

