/*
 * Decompiled with CFR 0.152.
 */
package capital.scalable.restdocs.jsondoclet;

import capital.scalable.restdocs.jsondoclet.ClassDocumentation;
import capital.scalable.restdocs.jsondoclet.DocletAbortException;
import capital.scalable.restdocs.jsondoclet.FallbackDirectoryOption;
import capital.scalable.restdocs.jsondoclet.WrappingOption;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.doclet.StandardDoclet;

public class ExtractDocumentationAsJsonDoclet
extends StandardDoclet {
    private String directoryLocationPath;

    @Override
    public boolean run(DocletEnvironment docEnv) {
        Path destinationDir = this.getDestinationDir();
        ObjectMapper mapper = ExtractDocumentationAsJsonDoclet.createObjectMapper();
        docEnv.getIncludedElements().stream().filter(e -> e.getKind().isClass() || e.getKind().isInterface()).forEach(classOrInterface -> ExtractDocumentationAsJsonDoclet.writeToFile(destinationDir, mapper, ExtractDocumentationAsJsonDoclet.findPackageElement(classOrInterface), (TypeElement)classOrInterface, ClassDocumentation.fromClassDoc(docEnv, classOrInterface)));
        return true;
    }

    private Path getDestinationDir() {
        String path = Objects.requireNonNullElse(this.directoryLocationPath, "../generated-javadoc-json");
        return Paths.get(path, new String[0]).toAbsolutePath();
    }

    public Set<Doclet.Option> getSupportedOptions() {
        HashSet<Doclet.Option> allOptions = new HashSet<Doclet.Option>(super.getSupportedOptions());
        Doclet.Option locationOption = allOptions.stream().filter(o -> o.getNames().contains("-d")).findFirst().orElseGet(FallbackDirectoryOption::new);
        WrappingOption wrapped = new WrappingOption(locationOption){

            @Override
            public boolean process(String option, List<String> arguments) {
                ExtractDocumentationAsJsonDoclet.this.directoryLocationPath = arguments.get(0);
                return true;
            }
        };
        allOptions.remove(locationOption);
        allOptions.add(wrapped);
        return allOptions;
    }

    private static PackageElement findPackageElement(Element classOrInterface) {
        Element pkg = classOrInterface.getEnclosingElement();
        int i = 10;
        while (!ElementKind.PACKAGE.equals((Object)pkg.getKind())) {
            if (i-- > 0) {
                pkg = pkg.getEnclosingElement();
                continue;
            }
            throw new DocletAbortException("Class or interface " + classOrInterface + "to deeply nested!");
        }
        return (PackageElement)pkg;
    }

    private static void writeToFile(Path destinationDir, ObjectMapper mapper, PackageElement packageElement, TypeElement classOrInterface, ClassDocumentation cd) {
        try {
            Path path = ExtractDocumentationAsJsonDoclet.path(destinationDir, packageElement, classOrInterface);
            try (BufferedWriter writer = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                mapper.writerFor(ClassDocumentation.class).writeValue((Writer)writer, (Object)cd);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new DocletAbortException("Error writing file: " + e);
        }
    }

    private static Path path(Path destinationDir, PackageElement packageElement, TypeElement classOrInterface) throws IOException {
        String packageName = packageElement.getQualifiedName().toString();
        String packageDir = packageName.replace(".", File.separator);
        Path packagePath = Paths.get(packageDir, new String[0]);
        Path path = destinationDir != null ? destinationDir.resolve(packageDir) : packagePath;
        Files.createDirectories(path, new FileAttribute[0]);
        String filename = classOrInterface.getQualifiedName().toString().replace(packageElement.getQualifiedName() + ".", "");
        return path.resolve(filename + ".json");
    }

    private static ObjectMapper createObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.setVisibility(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withCreatorVisibility(JsonAutoDetect.Visibility.NONE));
        return mapper;
    }
}

