/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.util;

import cloud.agileframework.spring.util.BeanUtil;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.servlet.LocaleResolver;

public class MessageUtil {
    private static LocaleResolver localeResolver;
    private static MessageSource messageSource;

    private static void init() {
        localeResolver = BeanUtil.getBean(LocaleResolver.class);
        if (localeResolver == null) {
            throw new NoSuchBeanDefinitionException(LocaleResolver.class);
        }
        messageSource = BeanUtil.getBean(MessageSource.class);
        if (messageSource == null) {
            throw new NoSuchBeanDefinitionException(MessageSource.class);
        }
    }

    public static String message(String key, Object ... params) {
        try {
            return MessageUtil.messageRequire(key, params);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String messageRequire(String key, Object ... params) {
        if (localeResolver == null || messageSource == null) {
            MessageUtil.init();
        }
        return messageSource.getMessage(key, params, LocaleContextHolder.getLocale());
    }
}

