/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.util;

import cloud.agileframework.common.util.array.ArrayUtil;
import cloud.agileframework.common.util.collection.IterablesUtil;
import cloud.agileframework.common.util.file.FileUtil;
import cloud.agileframework.common.util.properties.PropertiesUtil;
import cloud.agileframework.common.util.string.StringUtil;
import cloud.agileframework.spring.exception.CreateFileException;
import cloud.agileframework.spring.util.BeanUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.multipart.support.DefaultMultipartHttpServletRequest;
import org.springframework.web.multipart.support.StandardServletMultipartResolver;

public class MultipartFileUtil
extends FileUtil {
    private static String tempPath;

    public static String getFormat(MultipartFile file) {
        try {
            InputStream in = file.getInputStream();
            return MultipartFileUtil.getFormat((InputStream)in, (String)file.getOriginalFilename());
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Map<String, Object> getFileFormRequest(HttpServletRequest request) {
        int length = 16;
        HashMap<String, Object> map = new HashMap<String, Object>(16);
        DefaultMultipartHttpServletRequest multipartRequest = null;
        if (request instanceof DefaultMultipartHttpServletRequest) {
            multipartRequest = (DefaultMultipartHttpServletRequest)request;
        } else {
            MultipartResolver multipartResolver = BeanUtil.getBean(MultipartResolver.class);
            if (multipartResolver instanceof CommonsMultipartResolver) {
                CommonsMultipartResolver resolver = new CommonsMultipartResolver(request.getSession().getServletContext());
                multipartRequest = resolver.resolveMultipart(request);
            } else if (multipartResolver instanceof StandardServletMultipartResolver) {
                multipartRequest = new StandardServletMultipartResolver().resolveMultipart(request);
            }
        }
        if (multipartRequest == null) {
            return map;
        }
        Iterator fileNames = multipartRequest.getFileNames();
        while (fileNames.hasNext()) {
            String fileName = (String)fileNames.next();
            map.put(fileName, multipartRequest.getFiles(fileName));
        }
        map.putAll(multipartRequest.getParameterMap());
        return map;
    }

    public static boolean checkFileFormat(File file) {
        String format = PropertiesUtil.getProperty((String)"agile.upload.include_format");
        if (format.isEmpty()) {
            return true;
        }
        Object[] formats = format.split(",", -1);
        return ArrayUtil.contains((Object[])formats, (Object)MultipartFileUtil.getFormat((File)file));
    }

    public static ResponseEntity<byte[]> downloadFile(File file) throws FileNotFoundException {
        byte[] byteFile;
        try {
            byteFile = FileUtils.readFileToByteArray((File)file);
        }
        catch (IOException e) {
            throw new FileNotFoundException();
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headers.setContentLength(file.length());
        headers.setContentDispositionFormData("attachment", new String(file.getName().getBytes(StandardCharsets.UTF_8), StandardCharsets.ISO_8859_1));
        return new ResponseEntity((Object)byteFile, (MultiValueMap)headers, HttpStatus.CREATED);
    }

    public static ResponseEntity<byte[]> downloadFile(String filePath) throws FileNotFoundException {
        return MultipartFileUtil.downloadFile(new File(filePath));
    }

    public static void downloadFile(Object value, HttpServletRequest request, HttpServletResponse response) throws IOException {
        MultipartFileUtil.downloadFile((Object)value, (HttpServletRequest)request, (HttpServletResponse)response, (String)MultipartFileUtil.getTempPath());
    }

    public static void downloadZip(List<?> fileList, HttpServletRequest request, HttpServletResponse response) throws IOException {
        MultipartFileUtil.downloadFile(fileList, (HttpServletRequest)request, (HttpServletResponse)response, (String)MultipartFileUtil.getTempPath());
    }

    public static String getTempPath() {
        boolean is;
        if (!StringUtil.isBlank((CharSequence)tempPath)) {
            return tempPath;
        }
        MultipartProperties properties = BeanUtil.getBean(MultipartProperties.class);
        if (properties == null) {
            throw new RuntimeException("\u672a\u52a0\u8f7d\u5230\u7f13\u5b58\u6587\u4ef6\u76f8\u5173\u914d\u7f6e");
        }
        String filePath = properties.getLocation();
        File file = new File(filePath);
        if (!file.exists() && !(is = file.mkdirs())) {
            throw new RuntimeException("\u7f13\u5b58\u76ee\u5f55\u65e0\u6cd5\u521b\u5efa");
        }
        try {
            tempPath = file.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!tempPath.endsWith(File.separator)) {
            tempPath = tempPath + File.separator;
        }
        return tempPath;
    }

    public static List<String> uploadFile(Collection<MultipartFile> files, String dirName) {
        return MultipartFileUtil.uploadFile(files, dirName, null);
    }

    public static List<String> uploadFile(Collection<MultipartFile> files, String dirName, String fileName) {
        if (StringUtil.isEmpty((CharSequence)fileName)) {
            return files.stream().map(file -> {
                try {
                    return MultipartFileUtil.uploadFile(file, dirName);
                }
                catch (CreateFileException | IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }).filter(Objects::nonNull).collect(Collectors.toList());
        }
        return IterablesUtil.map((Integer)1, files, (index, file) -> {
            try {
                return MultipartFileUtil.uploadFile(file, dirName, String.format("%s(%s)", fileName, index));
            }
            catch (CreateFileException | IOException e) {
                e.printStackTrace();
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static String uploadFile(MultipartFile file) throws CreateFileException, IOException {
        return MultipartFileUtil.uploadFile(file, null);
    }

    public static String uploadFile(MultipartFile file, String dirName) throws CreateFileException, IOException {
        return MultipartFileUtil.uploadFile(file, dirName, null);
    }

    public static String uploadFile(MultipartFile file, String dirName, String fileName) throws CreateFileException, IOException {
        String string = dirName = StringUtil.isEmpty((CharSequence)dirName) ? "" : dirName;
        if (MultipartFileUtil.isIllegalDirName((String)dirName)) {
            throw new RuntimeException("\u975e\u6cd5\u76ee\u5f55\u7ed3\u6784\uff0c\u5b58\u5728\u88ab\u653b\u51fb\u5a01\u80c1");
        }
        String dirPath = MultipartFileUtil.getTempPath() + dirName;
        File dir = new File(dirPath);
        if (!dir.exists() && !dir.mkdirs()) {
            throw new CreateFileException(dir.getAbsolutePath());
        }
        try {
            dirPath = dir.getCanonicalPath();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!dirPath.endsWith(File.separator)) {
            dirPath = dirPath + File.separator;
        }
        fileName = StringUtil.isEmpty((CharSequence)fileName) ? file.getOriginalFilename() : fileName;
        String absoluteFileName = dirPath + fileName;
        File uploadFile = new File(absoluteFileName);
        if (!uploadFile.exists() && !uploadFile.createNewFile()) {
            throw new CreateFileException(absoluteFileName);
        }
        file.transferTo(uploadFile);
        return absoluteFileName;
    }

    public static File getFile(String fileName) throws FileNotFoundException {
        File file = fileName.startsWith(File.separator) ? new File(fileName) : new File(MultipartFileUtil.getTempPath() + fileName);
        if (file.exists()) {
            return file;
        }
        throw new FileNotFoundException(file.getAbsolutePath());
    }

    public static String toRelativePath(String absolutelyPath) {
        return absolutelyPath.replace(MultipartFileUtil.getTempPath(), "").replace(File.separator, "/");
    }
}

