/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.util;

import cloud.agileframework.common.util.clazz.TypeReference;
import cloud.agileframework.common.util.json.JSONUtil;
import cloud.agileframework.common.util.object.ObjectUtil;
import cloud.agileframework.spring.util.MultipartFileUtil;
import cloud.agileframework.spring.util.ServletUtil;
import com.google.common.collect.Maps;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;

public class ParamUtil {
    public static Map<String, Object> handleInParam(HttpServletRequest currentRequest) {
        int length = 16;
        Map<String, Object> inParam = new HashMap<String, Object>(16);
        if (currentRequest == null) {
            return inParam;
        }
        inParam = ParamUtil.parseOrdinaryVariable(currentRequest);
        return inParam;
    }

    public static Map<String, Object> handleInParamWithFile(HttpServletRequest currentRequest) {
        Map<String, Object> inParam = ParamUtil.handleInParam(currentRequest);
        if (currentRequest == null) {
            return inParam;
        }
        CommonsMultipartResolver multipartResolver = new CommonsMultipartResolver(currentRequest.getSession().getServletContext());
        if (multipartResolver.isMultipart(currentRequest)) {
            Map<String, Object> formData = MultipartFileUtil.getFileFormRequest(currentRequest);
            for (Map.Entry<String, Object> entry : formData.entrySet()) {
                if (inParam.containsKey(entry.getKey())) continue;
                inParam.put(entry.getKey(), entry.getValue());
            }
        }
        return inParam;
    }

    private static void combine(Map<String, Object> from, Map<String, Object> to) {
        to.forEach((key, value) -> {
            Object old = from.get(key);
            if (old == null) {
                from.put((String)key, value);
            } else if (Collection.class.isAssignableFrom(old.getClass())) {
                ((Collection)old).add(value);
            } else if (old.getClass().isArray()) {
                Object[] temp = new Object[Array.getLength(old) + 1];
                for (int i = 0; i < Array.getLength(old); ++i) {
                    temp[i] = Array.get(old, i);
                }
                temp[Array.getLength(old)] = value;
                from.put((String)key, temp);
            } else {
                Object[] temp = new Object[]{old, value};
                from.put((String)key, temp);
            }
        });
    }

    public static Map<String, Object> parseOrdinaryVariable(HttpServletRequest currentRequest) {
        String bodyParam;
        HashMap inParam = Maps.newHashMap();
        Map parameterMap = currentRequest.getParameterMap();
        if (parameterMap.size() > 0) {
            for (Map.Entry map : parameterMap.entrySet()) {
                String[] v = (String[])map.getValue();
                if (v.length == 1) {
                    inParam.put(map.getKey(), v[0]);
                    continue;
                }
                inParam.put(map.getKey(), v);
            }
        }
        if ((bodyParam = ServletUtil.getBody(currentRequest)) != null) {
            inParam.put("body", bodyParam);
        }
        Enumeration attributeNames = currentRequest.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String prefix;
            String key = (String)attributeNames.nextElement();
            if (!key.startsWith(prefix = "Parameter_")) continue;
            inParam.put(key.replace(prefix, ""), currentRequest.getAttribute(key));
        }
        return ParamUtil.coverToMap(inParam);
    }

    public static Object getInParam(Map<String, Object> map, String key) {
        return JSONUtil.pathGet((String)key, map);
    }

    public static <T> T getInParam(Map<String, Object> map, String key, T defaultValue) {
        Object value = ParamUtil.getInParam(map, key);
        if (value != null) {
            return (T)ObjectUtil.to((Object)value, (TypeReference)new TypeReference(defaultValue.getClass()));
        }
        return defaultValue;
    }

    public static <T> T getInParam(Map<String, Object> map, String key, Class<T> clazz, T defaultValue) {
        T value = ParamUtil.getInParam(map, key, clazz);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    public static <T> T getInParam(Map<String, Object> map, String key, TypeReference<T> typeReference) {
        return ParamUtil.getInParam(map, key, typeReference, null);
    }

    public static <T> T getInParam(Map<String, Object> map, String key, TypeReference<T> typeReference, T defaultValue) {
        Object value = ParamUtil.getInParam(map, key);
        if (value != null) {
            Object v = ObjectUtil.to((Object)value, typeReference);
            return (T)(v == null ? defaultValue : v);
        }
        return defaultValue;
    }

    public static MultipartFile getInParamOfFile(Map<String, Object> map, String key) {
        List<MultipartFile> files = ParamUtil.getInParamOfFiles(map, key);
        if (!files.isEmpty()) {
            return files.get(0);
        }
        return null;
    }

    public static List<MultipartFile> getInParamOfFiles(Map<String, Object> map, String key) {
        return (List)ParamUtil.getInParam(map, key);
    }

    public static boolean containsKey(Map<String, Object> map, String key) {
        Object value = ParamUtil.getInParam(map, key);
        return value != null;
    }

    private static Map<String, Object> coverToMap(Map<String, Object> map) {
        HashMap<String, Object> result = new HashMap<String, Object>(map);
        Object body = map.get("body");
        if (body != null) {
            try {
                Object json = JSONUtil.toMapOrList((Object)JSONUtil.toJSON((Object)body.toString()));
                if (json == null) {
                    return null;
                }
                if (Map.class.isAssignableFrom(json.getClass())) {
                    ParamUtil.combine(result, (Map)json);
                    result.remove("body");
                } else if (List.class.isAssignableFrom(json.getClass())) {
                    result.put("body", json);
                }
            }
            catch (Exception e) {
                result.put("body", body);
            }
        } else {
            result.remove("body");
        }
        return result;
    }

    public static <T> T getInParam(Map<String, Object> map, Class<T> clazz) {
        Object result = ObjectUtil.to(map, (TypeReference)new TypeReference<T>(clazz){});
        if (result == null || ObjectUtil.isAllNullValidity((Object)result)) {
            return null;
        }
        return (T)result;
    }

    public static <T> T getInParam(Map<String, Object> map, TypeReference<T> typeReference) {
        Object result = ObjectUtil.to(map, typeReference);
        if (result == null || ObjectUtil.isAllNullValidity((Object)result)) {
            return null;
        }
        return (T)result;
    }

    public static <T> T getInParam(Map<String, Object> map, String key, Class<T> clazz) {
        return (T)ObjectUtil.to((Object)JSONUtil.pathGet((String)key, map), (TypeReference)new TypeReference(clazz));
    }

    public static <T> List<T> getInParamOfArray(Map<String, Object> map, String key, Class<T> clazz) {
        Object value = JSONUtil.pathGet((String)key, map);
        return (List)ObjectUtil.to((Object)value, (TypeReference)new TypeReference(clazz));
    }

    public static String getInfo(HttpServletRequest request, String key) {
        Map<String, Object> map;
        Object tokenValue;
        String token = request.getHeader(key);
        if (StringUtils.isBlank((CharSequence)token) && (token = ParamUtil.getCookie(request, key)) == null && (tokenValue = (map = ParamUtil.handleInParam(request)).get(key)) != null) {
            return tokenValue.toString();
        }
        return token;
    }

    public static String getCookie(HttpServletRequest request, String key) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            if (!key.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }
}

