/*
 * Decompiled with CFR 0.152.
 */
package cloud.agileframework.spring.util;

import cloud.agileframework.spring.util.ParamUtil;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.ArrayUtils;
import org.springframework.web.util.ContentCachingRequestWrapper;

public class RequestWrapper
extends ContentCachingRequestWrapper {
    private final Map<String, String[]> params = Maps.newHashMap();
    private Map<String, Object> inParam;

    public RequestWrapper(HttpServletRequest request) {
        super(request);
        this.params.remove("service");
        this.params.remove("method");
        this.params.putAll(request.getParameterMap());
    }

    public static HttpServletRequest of(HttpServletRequest request) {
        if (!(request instanceof RequestWrapper)) {
            request = new RequestWrapper((HttpServletRequest)request);
        }
        return request;
    }

    public Map<String, String[]> getParameterMap() {
        return this.params;
    }

    public void addParameter(String key, String o) {
        if (this.params.containsKey(key)) {
            Object[] value = this.params.get(key);
            this.params.put(key, (String[])ArrayUtils.add((Object[])value, (Object)o));
        }
        this.params.put(key, new String[]{o});
    }

    public Map<String, Object> getInParam() {
        if (this.inParam == null) {
            this.inParam = Maps.newHashMap();
        }
        this.inParam.putAll(ParamUtil.handleInParam((HttpServletRequest)this));
        return this.inParam;
    }

    public Map<String, Object> getInParamWithFile() {
        if (this.inParam == null) {
            this.inParam = Maps.newHashMap();
        }
        this.inParam.putAll(ParamUtil.handleInParamWithFile((HttpServletRequest)this));
        return this.inParam;
    }

    public void extendInParam(Map<String, Object> params) {
        this.getInParam().putAll(params);
    }
}

