/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.cache.impl;

import cloud.tianai.captcha.cache.CacheStore;
import cloud.tianai.captcha.cache.impl.ConCurrentExpiringMap;
import cloud.tianai.captcha.cache.impl.ExpiringMap;
import cloud.tianai.captcha.common.AnyMap;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class LocalCacheStore
implements CacheStore {
    protected ExpiringMap<String, AnyMap> cache = new ConCurrentExpiringMap<String, AnyMap>();

    public LocalCacheStore() {
        this.cache.init();
    }

    @Override
    public AnyMap getCache(String key) {
        return (AnyMap)this.cache.get(key);
    }

    @Override
    public AnyMap getAndRemoveCache(String key) {
        return (AnyMap)this.cache.remove(key);
    }

    @Override
    public boolean setCache(String key, AnyMap data, Long expire, TimeUnit timeUnit) {
        this.cache.remove(key);
        this.cache.put(key, data, expire, timeUnit);
        return true;
    }

    @Override
    public Long incr(String key, long delta, Long expire, TimeUnit timeUnit) {
        Map value = (Map)this.cache.remove(key);
        if (value != null) {
            Long incr = (Long)value.get("___incr___");
            if (incr == null) {
                incr = 0L;
            }
            incr = incr + delta;
            this.cache.put(key, AnyMap.of(Collections.singletonMap("___incr___", incr)), expire, timeUnit);
            return incr;
        }
        this.cache.put(key, AnyMap.of(Collections.singletonMap("___incr___", delta)), expire, timeUnit);
        return delta;
    }

    @Override
    public Long getLong(String key) {
        Map stringObjectMap = (Map)this.cache.get(key);
        if (stringObjectMap != null) {
            return (Long)stringObjectMap.get("___incr___");
        }
        return null;
    }
}

