/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.generator.impl;

import cloud.tianai.captcha.generator.AbstractImageCaptchaGenerator;
import cloud.tianai.captcha.generator.common.model.dto.CaptchaExchange;
import cloud.tianai.captcha.generator.common.model.dto.ClickImageCheckDefinition;
import cloud.tianai.captcha.generator.common.model.dto.GenerateParam;
import cloud.tianai.captcha.generator.common.util.CaptchaImageUtils;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractClickImageCaptchaGenerator
extends AbstractImageCaptchaGenerator {
    public static final String CLICK_IMAGE_DISTORT_KEY = "clickImageDistort";

    public AbstractClickImageCaptchaGenerator(ImageCaptchaResourceManager imageCaptchaResourceManager) {
        super(imageCaptchaResourceManager);
    }

    public AbstractClickImageCaptchaGenerator() {
    }

    @Override
    public void doGenerateCaptchaImage(CaptchaExchange captchaExchange) {
        GenerateParam param = captchaExchange.getParam();
        Resource resourceImage = this.requiredRandomGetResource(param.getType(), param.getBackgroundImageTag());
        BufferedImage bgImage = this.getResourceImage(resourceImage);
        List<Resource> imgTips = this.randomGetClickImgTips(param);
        int allImages = imgTips.size();
        ArrayList<ClickImageCheckDefinition> clickImageCheckDefinitionList = new ArrayList<ClickImageCheckDefinition>(allImages);
        int avg = bgImage.getWidth() / allImages;
        if (allImages < imgTips.size()) {
            throw new IllegalStateException("\u968f\u673a\u751f\u6210\u70b9\u51fb\u56fe\u7247\u5c0f\u4e8e\u8bf7\u6c42\u6570\u91cf\uff0c \u8bf7\u6c42\u751f\u6210\u6570\u91cf=" + allImages + ",\u5b9e\u9645\u751f\u6210\u6570\u91cf=" + imgTips.size());
        }
        for (int i = 0; i < allImages; ++i) {
            ImgWrapper imgWrapper = this.getClickImg(imgTips.get(i), null);
            BufferedImage image = imgWrapper.getImage();
            int clickImgWidth = image.getWidth();
            int clickImgHeight = image.getHeight();
            int randomX = i == 0 ? 1 : avg * i;
            int randomY = this.randomInt(10, bgImage.getHeight() - clickImgHeight);
            CaptchaImageUtils.overlayImage(bgImage, image, randomX, randomY);
            ClickImageCheckDefinition clickImageCheckDefinition = new ClickImageCheckDefinition();
            clickImageCheckDefinition.setTip(imgWrapper.getTip());
            clickImageCheckDefinition.setX(randomX + clickImgWidth / 2);
            clickImageCheckDefinition.setY(randomY + clickImgHeight / 2);
            clickImageCheckDefinition.setWidth(clickImgWidth);
            clickImageCheckDefinition.setHeight(clickImgHeight);
            clickImageCheckDefinition.setImageColor(imgWrapper.getImageColor());
            clickImageCheckDefinitionList.add(clickImageCheckDefinition);
        }
        List<ClickImageCheckDefinition> checkClickImageCheckDefinitionList = this.filterAndSortClickImageCheckDefinition(captchaExchange, clickImageCheckDefinitionList);
        captchaExchange.setBackgroundImage(bgImage);
        captchaExchange.setTransferData(checkClickImageCheckDefinitionList);
        captchaExchange.setResourceImage(resourceImage);
    }

    protected abstract List<ClickImageCheckDefinition> filterAndSortClickImageCheckDefinition(CaptchaExchange var1, List<ClickImageCheckDefinition> var2);

    protected abstract List<Resource> randomGetClickImgTips(GenerateParam var1);

    public abstract ImgWrapper getClickImg(Resource var1, Color var2);

    public static class ImgWrapper {
        private BufferedImage image;
        private Resource tip;
        private Color imageColor;

        public BufferedImage getImage() {
            return this.image;
        }

        public Resource getTip() {
            return this.tip;
        }

        public Color getImageColor() {
            return this.imageColor;
        }

        public void setImage(BufferedImage image) {
            this.image = image;
        }

        public void setTip(Resource tip) {
            this.tip = tip;
        }

        public void setImageColor(Color imageColor) {
            this.imageColor = imageColor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ImgWrapper)) {
                return false;
            }
            ImgWrapper other = (ImgWrapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BufferedImage this$image = this.getImage();
            BufferedImage other$image = other.getImage();
            if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
                return false;
            }
            Resource this$tip = this.getTip();
            Resource other$tip = other.getTip();
            if (this$tip == null ? other$tip != null : !((Object)this$tip).equals(other$tip)) {
                return false;
            }
            Color this$imageColor = this.getImageColor();
            Color other$imageColor = other.getImageColor();
            return !(this$imageColor == null ? other$imageColor != null : !((Object)this$imageColor).equals(other$imageColor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ImgWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BufferedImage $image = this.getImage();
            result = result * 59 + ($image == null ? 43 : $image.hashCode());
            Resource $tip = this.getTip();
            result = result * 59 + ($tip == null ? 43 : ((Object)$tip).hashCode());
            Color $imageColor = this.getImageColor();
            result = result * 59 + ($imageColor == null ? 43 : ((Object)$imageColor).hashCode());
            return result;
        }

        public String toString() {
            return "AbstractClickImageCaptchaGenerator.ImgWrapper(image=" + this.getImage() + ", tip=" + this.getTip() + ", imageColor=" + this.getImageColor() + ")";
        }

        public ImgWrapper() {
        }

        public ImgWrapper(BufferedImage image, Resource tip, Color imageColor) {
            this.image = image;
            this.tip = tip;
            this.imageColor = imageColor;
        }
    }
}

