/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.resource;

import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.ResourceListener;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.common.model.dto.ResourceMap;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractResourceStore
implements ResourceStore {
    protected ChainListener listener = new ChainListener();
    boolean isInit = false;

    @Override
    public void init(ImageCaptchaResourceManager resourceManager) {
        if (this.isInit) {
            return;
        }
        this.doInit();
        this.isInit = true;
        this.listener.onInit(this, resourceManager);
    }

    @Override
    public void addListener(ResourceListener listener) {
        this.listener.removeListener(listener);
        this.listener.addListener(listener);
    }

    @Override
    public void addResource(String type, Resource resource) {
        this.doAddResource(type, resource);
        if (this.isInit) {
            this.listener.onAddResource(type, resource);
        }
    }

    @Override
    public void addTemplate(String type, ResourceMap template) {
        this.doAddTemplate(type, template);
        if (this.isInit) {
            this.listener.onAddTemplate(type, template);
        }
    }

    @Override
    public Resource deleteResource(String type, String id) {
        Resource resource = this.doDeleteResource(type, id);
        if (this.isInit && resource != null) {
            this.listener.onDeleteResource(type, resource);
        }
        return resource;
    }

    @Override
    public ResourceMap deleteTemplate(String type, String id) {
        ResourceMap resourceMap = this.doDeleteTemplate(type, id);
        if (this.isInit && resourceMap != null) {
            this.listener.onDeleteTemplate(type, resourceMap);
        }
        return resourceMap;
    }

    @Override
    public Resource randomGetResourceByTypeAndTag(String type, String tag) {
        Resource resource = this.doRandomGetResourceByTypeAndTag(type, tag);
        if (this.isInit && resource != null) {
            this.listener.onRandomGetResourceByTypeAndTag(type, tag, resource);
        }
        return resource;
    }

    @Override
    public ResourceMap randomGetTemplateByTypeAndTag(String type, String tag) {
        ResourceMap resourceMap = this.doRandomGetTemplateByTypeAndTag(type, tag);
        if (this.isInit && resourceMap != null) {
            this.listener.onRandomGetTemplateByTypeAndTag(type, tag, resourceMap);
        }
        return resourceMap;
    }

    @Override
    public void clearAllResources() {
        this.doClearAllResources();
        if (this.isInit) {
            this.listener.onClearAllResources();
        }
    }

    @Override
    public void clearAllTemplates() {
        this.doClearAllTemplates();
        if (this.isInit) {
            this.listener.onClearAllTemplates();
        }
    }

    public void doInit() {
    }

    public abstract void doClearAllResources();

    public abstract void doClearAllTemplates();

    public abstract Resource doRandomGetResourceByTypeAndTag(String var1, String var2);

    public abstract ResourceMap doRandomGetTemplateByTypeAndTag(String var1, String var2);

    public abstract ResourceMap doDeleteTemplate(String var1, String var2);

    public abstract Resource doDeleteResource(String var1, String var2);

    public abstract void doAddResource(String var1, Resource var2);

    public abstract void doAddTemplate(String var1, ResourceMap var2);

    public ChainListener getListener() {
        return this.listener;
    }

    public static class ChainListener
    implements ResourceListener {
        protected List<ResourceListener> listeners = new ArrayList<ResourceListener>();

        public void addListener(ResourceListener listener) {
            this.listeners.add(listener);
        }

        public void removeListener(ResourceListener listener) {
            this.listeners.remove(listener);
        }

        @Override
        public void onInit(ResourceStore resourceStore, ImageCaptchaResourceManager resourceManager) {
            for (ResourceListener listener : this.listeners) {
                listener.onInit(resourceStore, resourceManager);
            }
        }

        @Override
        public void onAddResource(String type, Resource resource) {
            for (ResourceListener listener : this.listeners) {
                listener.onAddResource(type, resource);
            }
        }

        @Override
        public void onAddTemplate(String type, ResourceMap template) {
            for (ResourceListener listener : this.listeners) {
                listener.onAddTemplate(type, template);
            }
        }

        @Override
        public void onClearAllResources() {
            for (ResourceListener listener : this.listeners) {
                listener.onClearAllResources();
            }
        }

        @Override
        public void onClearAllTemplates() {
            for (ResourceListener listener : this.listeners) {
                listener.onClearAllTemplates();
            }
        }

        @Override
        public void onRandomGetResourceByTypeAndTag(String type, String tag, Resource resource) {
            for (ResourceListener listener : this.listeners) {
                listener.onRandomGetResourceByTypeAndTag(type, tag, resource);
            }
        }

        @Override
        public void onRandomGetTemplateByTypeAndTag(String type, String tag, ResourceMap template) {
            for (ResourceListener listener : this.listeners) {
                listener.onRandomGetTemplateByTypeAndTag(type, tag, template);
            }
        }

        @Override
        public void onDeleteResource(String type, Resource resource) {
            for (ResourceListener listener : this.listeners) {
                listener.onDeleteResource(type, resource);
            }
        }

        @Override
        public void onDeleteTemplate(String type, ResourceMap template) {
            for (ResourceListener listener : this.listeners) {
                listener.onDeleteTemplate(type, template);
            }
        }
    }
}

