/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.resource;

import cloud.tianai.captcha.generator.impl.StandardSliderImageCaptchaGenerator;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.common.model.dto.ResourceMap;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class DefaultBuiltInResources {
    public static final String PATH_PREFIX = "classpath:META-INF/cut-image/template";
    private static Map<String, Consumer<ResourceStore>> defaultTemplateResource = new HashMap<String, Consumer<ResourceStore>>(8);

    public DefaultBuiltInResources(String defaultPathPrefix) {
        this.init(defaultPathPrefix);
    }

    private void init(String defaultPathPrefix) {
        String pathPrefix;
        String type;
        String[] split = defaultPathPrefix.split(":");
        if (split.length < 1) {
            type = "file";
            pathPrefix = defaultPathPrefix;
        } else {
            type = split[0];
            pathPrefix = split[1];
        }
        if (pathPrefix.endsWith("/")) {
            pathPrefix = pathPrefix.substring(0, pathPrefix.length() - 1);
        }
        String finalPathPrefix = pathPrefix;
        defaultTemplateResource.put("SLIDER", resourceStore -> {
            ResourceMap template1 = new ResourceMap("default", 4);
            template1.put(StandardSliderImageCaptchaGenerator.TEMPLATE_ACTIVE_IMAGE_NAME, new Resource(type, finalPathPrefix.concat("/slider_1/active.png")));
            template1.put(StandardSliderImageCaptchaGenerator.TEMPLATE_FIXED_IMAGE_NAME, new Resource(type, finalPathPrefix.concat("/slider_1/fixed.png")));
            resourceStore.addTemplate("SLIDER", template1);
            ResourceMap template2 = new ResourceMap("default", 4);
            template2.put(StandardSliderImageCaptchaGenerator.TEMPLATE_ACTIVE_IMAGE_NAME, new Resource(type, finalPathPrefix.concat("/slider_2/active.png")));
            template2.put(StandardSliderImageCaptchaGenerator.TEMPLATE_FIXED_IMAGE_NAME, new Resource(type, finalPathPrefix.concat("/slider_2/fixed.png")));
            resourceStore.addTemplate("SLIDER", template2);
        });
        defaultTemplateResource.put("ROTATE", resourceStore -> {
            ResourceMap template1 = new ResourceMap("default", 4);
            template1.put(StandardSliderImageCaptchaGenerator.TEMPLATE_ACTIVE_IMAGE_NAME, new Resource(type, finalPathPrefix.concat("/rotate_1/active.png")));
            template1.put(StandardSliderImageCaptchaGenerator.TEMPLATE_FIXED_IMAGE_NAME, new Resource(type, finalPathPrefix.concat("/rotate_1/fixed.png")));
            resourceStore.addTemplate("ROTATE", template1);
        });
    }

    public void addDefaultTemplate(String type, ResourceStore resourceStore) {
        Consumer<ResourceStore> resourceStoreConsumer = defaultTemplateResource.get(type);
        if (resourceStoreConsumer == null) {
            return;
        }
        resourceStoreConsumer.accept(resourceStore);
    }

    public void addDefaultTemplate(ResourceStore resourceStore) {
        defaultTemplateResource.forEach((type, consumer) -> consumer.accept(resourceStore));
    }
}

