/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.resource;

import cloud.tianai.captcha.generator.common.FontWrapper;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.ResourceListener;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FontCache
implements ResourceListener {
    private static final Logger log = LoggerFactory.getLogger(FontCache.class);
    public static final String FONT_TYPE = "font";
    private final Map<String, FontWrapper> fontMap = new ConcurrentHashMap<String, FontWrapper>();
    private ResourceStore resourceStore;
    private ImageCaptchaResourceManager resourceManager;
    private int fontSize = 70;

    public static FontCache getInstance() {
        return INSTANCE.INSTANCE;
    }

    @Override
    public void onInit(ResourceStore resourceStore, ImageCaptchaResourceManager resourceManager) {
        this.resourceStore = resourceStore;
        this.resourceManager = resourceManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FontWrapper getFont(Resource resource) {
        try (InputStream stream = this.resourceManager.getResourceInputStream(resource);){
            Font font = Font.createFont(0, stream);
            FontWrapper fontWrapper = new FontWrapper(font, this.fontSize);
            return fontWrapper;
        }
        catch (FontFormatException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void onAddResource(String type, Resource resource) {
        if (FONT_TYPE.equalsIgnoreCase(type)) {
            this.fontMap.computeIfAbsent(resource.getId(), v -> this.getFont(resource));
        }
    }

    @Override
    public void onDeleteResource(String type, Resource resource) {
        if (FONT_TYPE.equalsIgnoreCase(type)) {
            this.fontMap.remove(resource.getId());
        }
    }

    @Override
    public void onClearAllResources() {
        this.fontMap.clear();
    }

    @Override
    public void onRandomGetResourceByTypeAndTag(String type, String tag, Resource resource) {
        if (FONT_TYPE.equalsIgnoreCase(type)) {
            FontWrapper fontWrapper = this.fontMap.computeIfAbsent(resource.getId(), v -> this.getFont(resource));
            resource.setExtra(fontWrapper);
        }
    }

    public void loadAllFonts() {
        List<Resource> resources = this.resourceStore.listResourcesByTypeAndTag(FONT_TYPE, null);
        for (Resource resource : resources) {
            this.fontMap.computeIfAbsent(resource.getId(), v -> this.getFont(resource));
        }
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    private static class INSTANCE {
        private static final FontCache INSTANCE = new FontCache();

        private INSTANCE() {
        }
    }
}

