/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.resource.impl;

import cloud.tianai.captcha.resource.FontCache;
import cloud.tianai.captcha.resource.ImageCaptchaResourceManager;
import cloud.tianai.captcha.resource.ResourceProvider;
import cloud.tianai.captcha.resource.ResourceProviders;
import cloud.tianai.captcha.resource.ResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.common.model.dto.ResourceMap;
import cloud.tianai.captcha.resource.impl.LocalMemoryResourceStore;
import java.io.InputStream;
import java.util.List;

public class DefaultImageCaptchaResourceManager
implements ImageCaptchaResourceManager {
    private ResourceStore resourceStore;
    private ResourceProviders resourceProviders;

    public DefaultImageCaptchaResourceManager() {
        this.init();
    }

    public DefaultImageCaptchaResourceManager(ResourceStore resourceStore, ResourceProviders resourceProviders) {
        this.resourceStore = resourceStore;
        this.resourceProviders = resourceProviders;
        this.init();
    }

    private void init() {
        if (this.resourceStore == null) {
            this.resourceStore = new LocalMemoryResourceStore();
        }
        this.resourceStore.addListener(FontCache.getInstance());
        this.resourceStore.init(this);
    }

    @Override
    public ResourceMap randomGetTemplate(String type, String tag) {
        ResourceMap resourceMap = this.resourceStore.randomGetTemplateByTypeAndTag(type, tag);
        if (resourceMap == null) {
            throw new IllegalStateException("\u968f\u673a\u83b7\u53d6\u6a21\u677f\u9519\u8bef\uff0cstore\u4e2d\u6a21\u677f\u4e3a\u7a7a, type:" + type);
        }
        return resourceMap;
    }

    @Override
    public Resource randomGetResource(String type, String tag) {
        Resource resource = this.resourceStore.randomGetResourceByTypeAndTag(type, tag);
        if (resource == null) {
            throw new IllegalStateException("\u968f\u673a\u83b7\u53d6\u8d44\u6e90\u9519\u8bef\uff0cstore\u4e2d\u8d44\u6e90\u4e3a\u7a7a, type:" + type);
        }
        return resource;
    }

    @Override
    public InputStream getResourceInputStream(Resource resource) {
        return this.resourceProviders.getResourceInputStream(resource);
    }

    @Override
    public List<ResourceProvider> listResourceProviders() {
        return this.resourceProviders.listResourceProviders();
    }

    @Override
    public void registerResourceProvider(ResourceProvider resourceProvider) {
        this.resourceProviders.registerResourceProvider(resourceProvider);
    }

    @Override
    public boolean deleteResourceProviderByName(String name) {
        return this.resourceProviders.deleteResourceProviderByName(name);
    }

    @Override
    public void setResourceStore(ResourceStore resourceStore) {
        this.resourceStore = resourceStore;
    }

    @Override
    public ResourceStore getResourceStore() {
        return this.resourceStore;
    }

    public ResourceProviders getResourceProviders() {
        return this.resourceProviders;
    }
}

