/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.resource.impl;

import cloud.tianai.captcha.common.util.CollectionUtils;
import cloud.tianai.captcha.common.util.ObjectUtils;
import cloud.tianai.captcha.resource.AbstractResourceStore;
import cloud.tianai.captcha.resource.common.model.dto.Resource;
import cloud.tianai.captcha.resource.common.model.dto.ResourceMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;

public class LocalMemoryResourceStore
extends AbstractResourceStore {
    private static final String TYPE_TAG_SPLIT_FLAG = "|";
    private Map<String, List<ResourceMap>> templateResourceTagMap = new HashMap<String, List<ResourceMap>>(2);
    private Map<String, List<Resource>> resourceTagMap = new HashMap<String, List<Resource>>(2);

    @Override
    public void doAddResource(String type, Resource resource) {
        if (ObjectUtils.isEmpty(resource.getTag())) {
            resource.setTag("default");
        }
        this.resourceTagMap.computeIfAbsent(this.mergeTypeAndTag(type, resource.getTag()), k -> new ArrayList(20)).add(resource);
    }

    @Override
    public void doAddTemplate(String type, ResourceMap template) {
        if (ObjectUtils.isEmpty(template.getTag())) {
            template.setTag("default");
        }
        this.templateResourceTagMap.computeIfAbsent(this.mergeTypeAndTag(type, template.getTag()), k -> new ArrayList(2)).add(template);
    }

    @Override
    public Resource doDeleteResource(String type, String id) {
        for (Map.Entry<String, List<Resource>> entry : this.resourceTagMap.entrySet()) {
            String k = entry.getKey();
            List<Resource> v = entry.getValue();
            String splitType = this.splitTypeTag(k)[0];
            if (!splitType.equals(type)) continue;
            Iterator<Resource> iterator = v.iterator();
            while (iterator.hasNext()) {
                Resource next = iterator.next();
                if (!next.getId().equals(id)) continue;
                iterator.remove();
                return next;
            }
        }
        return null;
    }

    @Override
    public ResourceMap doDeleteTemplate(String type, String id) {
        for (Map.Entry<String, List<ResourceMap>> entry : this.templateResourceTagMap.entrySet()) {
            String k = entry.getKey();
            List<ResourceMap> v = entry.getValue();
            String splitType = this.splitTypeTag(k)[0];
            if (!splitType.equals(type)) continue;
            Iterator<ResourceMap> iterator = v.iterator();
            while (iterator.hasNext()) {
                ResourceMap next = iterator.next();
                if (!next.getId().equals(id)) continue;
                iterator.remove();
                return next;
            }
        }
        return null;
    }

    @Override
    public List<Resource> listResourcesByTypeAndTag(String type, String tag) {
        if (!ObjectUtils.isEmpty(tag)) {
            return this.resourceTagMap.get(this.mergeTypeAndTag(type, tag));
        }
        ArrayList<Resource> resourceList = new ArrayList<Resource>();
        this.resourceTagMap.forEach((k, v) -> {
            String splitType = this.splitTypeTag((String)k)[0];
            if (splitType.equals(type)) {
                resourceList.addAll((Collection<Resource>)v);
            }
        });
        return resourceList;
    }

    @Override
    public List<ResourceMap> listTemplatesByTypeAndTag(String type, String tag) {
        if (!ObjectUtils.isEmpty(tag)) {
            return this.templateResourceTagMap.get(this.mergeTypeAndTag(type, tag));
        }
        ArrayList<ResourceMap> resourceMapList = new ArrayList<ResourceMap>();
        this.templateResourceTagMap.forEach((k, v) -> {
            String splitType = this.splitTypeTag((String)k)[0];
            if (splitType.equals(type)) {
                resourceMapList.addAll((Collection<ResourceMap>)v);
            }
        });
        return resourceMapList;
    }

    @Override
    public Resource doRandomGetResourceByTypeAndTag(String type, String tag) {
        List<Resource> resources = this.resourceTagMap.get(this.mergeTypeAndTag(type, tag));
        if (CollectionUtils.isEmpty(resources)) {
            throw new IllegalStateException("\u968f\u673a\u83b7\u53d6\u8d44\u6e90\u9519\u8bef\uff0cstore\u4e2d\u8d44\u6e90\u4e3a\u7a7a, type:" + type + ",tag:" + tag);
        }
        if (resources.size() == 1) {
            return resources.get(0);
        }
        int randomIndex = ThreadLocalRandom.current().nextInt(resources.size());
        try {
            return resources.get(randomIndex);
        }
        catch (IndexOutOfBoundsException e) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.doRandomGetResourceByTypeAndTag(type, tag);
        }
    }

    @Override
    public ResourceMap doRandomGetTemplateByTypeAndTag(String type, String tag) {
        List<ResourceMap> templateList = this.templateResourceTagMap.get(this.mergeTypeAndTag(type, tag));
        if (CollectionUtils.isEmpty(templateList)) {
            throw new IllegalStateException("\u968f\u673a\u83b7\u53d6\u6a21\u677f\u9519\u8bef\uff0cstore\u4e2d\u6a21\u677f\u4e3a\u7a7a, type:" + type + ",tag:" + tag);
        }
        if (templateList.size() == 1) {
            return templateList.get(0);
        }
        int randomIndex = ThreadLocalRandom.current().nextInt(templateList.size());
        try {
            return templateList.get(randomIndex);
        }
        catch (IndexOutOfBoundsException e) {
            try {
                Thread.sleep(0L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.doRandomGetTemplateByTypeAndTag(type, tag);
        }
    }

    public String mergeTypeAndTag(String type, String tag) {
        if (tag == null) {
            tag = "default";
        }
        return type + TYPE_TAG_SPLIT_FLAG + tag;
    }

    public String[] splitTypeTag(String k) {
        return k.split("\\|");
    }

    public void clearResources(String type, String tag) {
        this.resourceTagMap.remove(this.mergeTypeAndTag(type, tag));
    }

    @Override
    public void doClearAllResources() {
        this.resourceTagMap.clear();
    }

    public Map<String, List<Resource>> listAllResources() {
        return this.resourceTagMap;
    }

    public List<Resource> listResourcesByType(String type, String tag) {
        return this.resourceTagMap.getOrDefault(this.mergeTypeAndTag(type, tag), Collections.emptyList());
    }

    public int getAllResourceCount() {
        int count = 0;
        for (List<Resource> value : this.resourceTagMap.values()) {
            count += value.size();
        }
        return count;
    }

    public int getResourceCount(String type, String tag) {
        return this.resourceTagMap.getOrDefault(this.mergeTypeAndTag(type, tag), Collections.emptyList()).size();
    }

    @Override
    public void doClearAllTemplates() {
        this.templateResourceTagMap.clear();
    }

    public void clearTemplates(String type, String tag) {
        this.templateResourceTagMap.remove(this.mergeTypeAndTag(type, tag));
    }

    public List<ResourceMap> listTemplatesByType(String type, String tag) {
        return this.templateResourceTagMap.getOrDefault(this.mergeTypeAndTag(type, tag), Collections.emptyList());
    }

    public Map<String, List<ResourceMap>> listAllTemplates() {
        return this.templateResourceTagMap;
    }
}

