/*
 * Decompiled with CFR 0.152.
 */
package cloud.tianai.captcha.validator.impl;

import cloud.tianai.captcha.common.AnyMap;
import cloud.tianai.captcha.common.response.ApiResponse;
import cloud.tianai.captcha.common.response.CodeDefinition;
import cloud.tianai.captcha.common.util.CaptchaTypeClassifier;
import cloud.tianai.captcha.common.util.CollectionUtils;
import cloud.tianai.captcha.common.util.ObjectUtils;
import cloud.tianai.captcha.validator.common.model.dto.ImageCaptchaTrack;
import cloud.tianai.captcha.validator.impl.SimpleImageCaptchaValidator;
import java.util.List;

public class BasicCaptchaTrackValidator
extends SimpleImageCaptchaValidator {
    public static final CodeDefinition DEFINITION = new CodeDefinition(50001, "basic check fail");

    public BasicCaptchaTrackValidator() {
    }

    public BasicCaptchaTrackValidator(float defaultTolerant) {
        super(defaultTolerant);
    }

    @Override
    public ApiResponse<?> beforeValid(ImageCaptchaTrack imageCaptchaTrack, AnyMap captchaValidData, Float tolerant, String type) {
        this.checkParam(imageCaptchaTrack);
        return ApiResponse.ofSuccess();
    }

    @Override
    public ApiResponse<?> afterValid(Boolean basicValid, ImageCaptchaTrack imageCaptchaTrack, AnyMap captchaValidData, Float tolerant, String type) {
        boolean check;
        if (!basicValid.booleanValue()) {
            return ApiResponse.ofSuccess();
        }
        if (!CaptchaTypeClassifier.isSliderCaptcha(type)) {
            return ApiResponse.ofSuccess();
        }
        long startSlidingTime = imageCaptchaTrack.getStartTime().getTime();
        long endSlidingTime = imageCaptchaTrack.getStopTime().getTime();
        Integer bgImageWidth = imageCaptchaTrack.getBgImageWidth();
        List<ImageCaptchaTrack.Track> trackList = imageCaptchaTrack.getTrackList();
        if (startSlidingTime + 300L > endSlidingTime) {
            return ApiResponse.ofMessage(DEFINITION);
        }
        if (trackList.size() < 10 || trackList.size() > bgImageWidth * 5) {
            return ApiResponse.ofMessage(DEFINITION);
        }
        ImageCaptchaTrack.Track firstTrack = trackList.get(0);
        if (firstTrack.getX().floatValue() > 10.0f || firstTrack.getX().floatValue() < -10.0f || firstTrack.getY().floatValue() > 10.0f || firstTrack.getY().floatValue() < -10.0f) {
            return ApiResponse.ofMessage(DEFINITION);
        }
        int check4 = 0;
        int check7 = 0;
        for (int i = 1; i < trackList.size(); ++i) {
            ImageCaptchaTrack.Track track = trackList.get(i);
            float x = track.getX().floatValue();
            float y = track.getY().floatValue();
            if (firstTrack.getY().floatValue() == y) {
                ++check4;
            }
            if (x >= (float)bgImageWidth.intValue()) {
                ++check7;
            }
            ImageCaptchaTrack.Track preTrack = trackList.get(i - 1);
            if (!(track.getX().floatValue() - preTrack.getX().floatValue() > 50.0f) && !(track.getY().floatValue() - preTrack.getY().floatValue() > 50.0f)) continue;
            return ApiResponse.ofMessage(DEFINITION);
        }
        if (check4 == trackList.size() || check7 > 200) {
            return ApiResponse.ofMessage(DEFINITION);
        }
        int splitPos = (int)((double)trackList.size() * 0.7);
        ImageCaptchaTrack.Track splitPostTrack = trackList.get(splitPos - 1);
        float posTime = splitPostTrack.getT().floatValue();
        float startAvgPosTime = posTime / (float)splitPos;
        ImageCaptchaTrack.Track lastTrack = trackList.get(trackList.size() - 1);
        double endAvgPosTime = lastTrack.getT().floatValue() / (float)(trackList.size() - splitPos);
        boolean bl = check = endAvgPosTime > (double)startAvgPosTime;
        if (check) {
            return ApiResponse.ofSuccess();
        }
        return ApiResponse.ofMessage(DEFINITION);
    }

    public void checkParam(ImageCaptchaTrack imageCaptchaTrack) {
        if (ObjectUtils.isEmpty(imageCaptchaTrack.getBgImageWidth())) {
            throw new IllegalArgumentException("bgImageWidth must not be null");
        }
        if (ObjectUtils.isEmpty(imageCaptchaTrack.getBgImageHeight())) {
            throw new IllegalArgumentException("bgImageHeight must not be null");
        }
        if (ObjectUtils.isEmpty(imageCaptchaTrack.getStartTime())) {
            throw new IllegalArgumentException("startSlidingTime must not be null");
        }
        if (ObjectUtils.isEmpty(imageCaptchaTrack.getStopTime())) {
            throw new IllegalArgumentException("endSlidingTime must not be null");
        }
        if (CollectionUtils.isEmpty(imageCaptchaTrack.getTrackList())) {
            throw new IllegalArgumentException("trackList must not be null");
        }
        for (ImageCaptchaTrack.Track track : imageCaptchaTrack.getTrackList()) {
            Float x = track.getX();
            Float y = track.getY();
            Float t = track.getT();
            String type = track.getType();
            if (x != null && y != null && t != null && !ObjectUtils.isEmpty(type)) continue;
            throw new IllegalArgumentException("track[x,y,t,type] must not be null");
        }
    }
}

