/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.ai.core;

import cn.hutool.ai.core.AIConfig;
import cn.hutool.core.util.ServiceLoaderUtil;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public class AIConfigRegistry {
    private static final Map<String, Class<? extends AIConfig>> configClasses = new ConcurrentHashMap<String, Class<? extends AIConfig>>();

    public static Class<? extends AIConfig> getConfigClass(String modelName) {
        return configClasses.get(modelName.toLowerCase());
    }

    static {
        ServiceLoader loader = ServiceLoaderUtil.load(AIConfig.class);
        for (AIConfig config : loader) {
            configClasses.put(config.getModelName().toLowerCase(), config.getClass());
        }
    }
}

