/*
 * Decompiled with CFR 0.152.
 */
package cn.xinyue365.common;

import cn.xinyue365.common.AbstractRequest;
import cn.xinyue365.common.AbstractResponse;
import cn.xinyue365.common.Credential;
import cn.xinyue365.common.ResponseFactory;
import cn.xinyue365.common.Sign;
import cn.xinyue365.common.http.HttpConnection;
import cn.xinyue365.common.profile.HttpProfile;
import com.google.gson.Gson;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.time.Instant;
import java.util.List;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public abstract class AbstractClient {
    protected static final Gson gson = new Gson();
    protected final Credential credential;
    protected final String endpoint;
    private HttpConnection httpConnection;

    protected AbstractClient(Credential credential, String endpoint) {
        this.credential = credential;
        this.endpoint = endpoint;
    }

    public AbstractClient(Credential credential, HttpProfile httpProfile, String endpoint) {
        this.credential = credential;
        this.endpoint = endpoint;
        this.httpConnection = new HttpConnection(httpProfile.getConnTimeout(), httpProfile.getReadTimeout(), httpProfile.getWriteTimeout());
    }

    protected <T extends AbstractResponse<?>> T postCall(String action, AbstractRequest request, Class<T> responseClass) {
        try {
            String timestamp = String.valueOf(Instant.now().getEpochSecond());
            String payload = request.toJson();
            String stringToSign = action + "\\n" + timestamp;
            String signature = Sign.sign(stringToSign, this.credential.getSecretKey());
            Headers.Builder headerBuilder = new Headers.Builder().add("Content-Type", "application/json").add("Authorization", signature).add("X-Timestamp", timestamp).add("X-Secret-Id", this.credential.getSecretId());
            String responseStr = this.httpConnection.postRequest(this.endpoint + action, RequestBody.create((String)payload, (MediaType)MediaType.parse((String)"application/json")), headerBuilder.build());
            return (T)((AbstractResponse)new Gson().fromJson(responseStr, responseClass));
        }
        catch (IOException e) {
            return ResponseFactory.failure(responseClass, e);
        }
    }

    protected <T extends AbstractResponse<?>> T postCallWithForm(String action, AbstractRequest request, Class<T> responseClass) {
        try {
            Field[] fields;
            String timestamp = String.valueOf(Instant.now().getEpochSecond());
            String stringToSign = action + "\\n" + timestamp;
            String signature = Sign.sign(stringToSign, this.credential.getSecretKey());
            Headers.Builder headerBuilder = new Headers.Builder().add("Content-Type", "application/json").add("Authorization", signature).add("X-Timestamp", timestamp).add("X-Secret-Id", this.credential.getSecretId());
            MultipartBody.Builder multipartBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            for (Field field : fields = request.getClass().getDeclaredFields()) {
                field.setAccessible(true);
                Object value = field.get(request);
                if (value == null) continue;
                if (value instanceof List) {
                    List list = (List)value;
                    for (Object item : list) {
                        multipartBuilder.addFormDataPart(field.getName(), item.toString());
                    }
                    continue;
                }
                if (value instanceof File) {
                    File file = (File)value;
                    multipartBuilder.addFormDataPart("file", file.getName(), RequestBody.create((File)file, (MediaType)MediaType.parse((String)"application/octet-stream")));
                    continue;
                }
                multipartBuilder.addFormDataPart(field.getName(), value.toString());
            }
            String responseStr = this.httpConnection.postRequest(this.endpoint + action, (RequestBody)multipartBuilder.build(), headerBuilder.build());
            return (T)((AbstractResponse)new Gson().fromJson(responseStr, responseClass));
        }
        catch (IOException | IllegalAccessException e) {
            return ResponseFactory.failure(responseClass, e);
        }
    }
}

