/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.inference.InferenceResponse;
import co.elastic.clients.elasticsearch.inference.TaskType;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class InferenceRequest
extends RequestBase
implements JsonpSerializable {
    private final List<String> input;
    private final String modelId;
    @Nullable
    private final JsonData taskSettings;
    private final TaskType taskType;
    public static final JsonpDeserializer<InferenceRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, InferenceRequest::setupInferenceRequestDeserializer);
    public static final Endpoint<InferenceRequest, InferenceResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<InferenceRequest, InferenceResponse>("es/inference.inference", request -> "POST", request -> {
        boolean _modelId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_inference");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.taskType.jsonValue(), buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.modelId, buf);
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _modelId = true;
        int _taskType = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("taskType", request.taskType.jsonValue());
            params.put("modelId", request.modelId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, InferenceResponse._DESERIALIZER);

    private InferenceRequest(Builder builder) {
        this.input = ApiTypeHelper.unmodifiableRequired(builder.input, (Object)this, "input");
        this.modelId = ApiTypeHelper.requireNonNull(builder.modelId, this, "modelId");
        this.taskSettings = builder.taskSettings;
        this.taskType = ApiTypeHelper.requireNonNull(builder.taskType, this, "taskType");
    }

    public static InferenceRequest of(Function<Builder, ObjectBuilder<InferenceRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> input() {
        return this.input;
    }

    public final String modelId() {
        return this.modelId;
    }

    @Nullable
    public final JsonData taskSettings() {
        return this.taskSettings;
    }

    public final TaskType taskType() {
        return this.taskType;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.input)) {
            generator.writeKey("input");
            generator.writeStartArray();
            for (String item0 : this.input) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.taskSettings != null) {
            generator.writeKey("task_settings");
            this.taskSettings.serialize(generator, mapper);
        }
    }

    protected static void setupInferenceRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::input, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "input");
        op.add(Builder::taskSettings, JsonData._DESERIALIZER, "task_settings");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<InferenceRequest> {
        private List<String> input;
        private String modelId;
        @Nullable
        private JsonData taskSettings;
        private TaskType taskType;

        public final Builder input(List<String> list) {
            this.input = Builder._listAddAll(this.input, list);
            return this;
        }

        public final Builder input(String value, String ... values) {
            this.input = Builder._listAdd(this.input, value, values);
            return this;
        }

        public final Builder modelId(String value) {
            this.modelId = value;
            return this;
        }

        public final Builder taskSettings(@Nullable JsonData value) {
            this.taskSettings = value;
            return this;
        }

        public final Builder taskType(TaskType value) {
            this.taskType = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public InferenceRequest build() {
            this._checkSingleUse();
            return new InferenceRequest(this);
        }
    }
}

