/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.inference;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class AdaptiveAllocations
implements JsonpSerializable {
    @Nullable
    private final Boolean enabled;
    @Nullable
    private final Integer maxNumberOfAllocations;
    @Nullable
    private final Integer minNumberOfAllocations;
    public static final JsonpDeserializer<AdaptiveAllocations> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AdaptiveAllocations::setupAdaptiveAllocationsDeserializer);

    private AdaptiveAllocations(Builder builder) {
        this.enabled = builder.enabled;
        this.maxNumberOfAllocations = builder.maxNumberOfAllocations;
        this.minNumberOfAllocations = builder.minNumberOfAllocations;
    }

    public static AdaptiveAllocations of(Function<Builder, ObjectBuilder<AdaptiveAllocations>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean enabled() {
        return this.enabled;
    }

    @Nullable
    public final Integer maxNumberOfAllocations() {
        return this.maxNumberOfAllocations;
    }

    @Nullable
    public final Integer minNumberOfAllocations() {
        return this.minNumberOfAllocations;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.enabled != null) {
            generator.writeKey("enabled");
            generator.write(this.enabled.booleanValue());
        }
        if (this.maxNumberOfAllocations != null) {
            generator.writeKey("max_number_of_allocations");
            generator.write(this.maxNumberOfAllocations.intValue());
        }
        if (this.minNumberOfAllocations != null) {
            generator.writeKey("min_number_of_allocations");
            generator.write(this.minNumberOfAllocations.intValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAdaptiveAllocationsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::enabled, JsonpDeserializer.booleanDeserializer(), "enabled");
        op.add(Builder::maxNumberOfAllocations, JsonpDeserializer.integerDeserializer(), "max_number_of_allocations");
        op.add(Builder::minNumberOfAllocations, JsonpDeserializer.integerDeserializer(), "min_number_of_allocations");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AdaptiveAllocations> {
        @Nullable
        private Boolean enabled;
        @Nullable
        private Integer maxNumberOfAllocations;
        @Nullable
        private Integer minNumberOfAllocations;

        public final Builder enabled(@Nullable Boolean value) {
            this.enabled = value;
            return this;
        }

        public final Builder maxNumberOfAllocations(@Nullable Integer value) {
            this.maxNumberOfAllocations = value;
            return this;
        }

        public final Builder minNumberOfAllocations(@Nullable Integer value) {
            this.minNumberOfAllocations = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AdaptiveAllocations build() {
            this._checkSingleUse();
            return new AdaptiveAllocations(this);
        }
    }
}

