/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.security.query_user;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch.security.User;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class QueryUser
extends User {
    private final List<FieldValue> sort;
    public static final JsonpDeserializer<QueryUser> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, QueryUser::setupQueryUserDeserializer);

    private QueryUser(Builder builder) {
        super(builder);
        this.sort = ApiTypeHelper.unmodifiable(builder.sort);
    }

    public static QueryUser of(Function<Builder, ObjectBuilder<QueryUser>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<FieldValue> sort() {
        return this.sort;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.sort)) {
            generator.writeKey("_sort");
            generator.writeStartArray();
            for (FieldValue item0 : this.sort) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    protected static void setupQueryUserDeserializer(ObjectDeserializer<Builder> op) {
        User.setupUserDeserializer(op);
        op.add(Builder::sort, JsonpDeserializer.arrayDeserializer(FieldValue._DESERIALIZER), "_sort");
    }

    public static class Builder
    extends User.AbstractBuilder<Builder>
    implements ObjectBuilder<QueryUser> {
        @Nullable
        private List<FieldValue> sort;

        public final Builder sort(List<FieldValue> list) {
            this.sort = Builder._listAddAll(this.sort, list);
            return this;
        }

        public final Builder sort(FieldValue value, FieldValue ... values) {
            this.sort = Builder._listAdd(this.sort, value, values);
            return this;
        }

        public final Builder sort(String value, String ... values) {
            this.sort = Builder._listAdd(this.sort, FieldValue.of(value), new FieldValue[0]);
            for (String v : values) {
                Builder._listAdd(this.sort, FieldValue.of(v), new FieldValue[0]);
            }
            return this;
        }

        public final Builder sort(long value, long ... values) {
            this.sort = Builder._listAdd(this.sort, FieldValue.of(value), new FieldValue[0]);
            for (long v : values) {
                Builder._listAdd(this.sort, FieldValue.of(v), new FieldValue[0]);
            }
            return this;
        }

        public final Builder sort(double value, double ... values) {
            this.sort = Builder._listAdd(this.sort, FieldValue.of(value), new FieldValue[0]);
            for (double v : values) {
                Builder._listAdd(this.sort, FieldValue.of(v), new FieldValue[0]);
            }
            return this;
        }

        public final Builder sort(boolean value, boolean ... values) {
            this.sort = Builder._listAdd(this.sort, FieldValue.of(value), new FieldValue[0]);
            for (boolean v : values) {
                Builder._listAdd(this.sort, FieldValue.of(v), new FieldValue[0]);
            }
            return this;
        }

        public final Builder sort(Function<FieldValue.Builder, ObjectBuilder<FieldValue>> fn) {
            return this.sort(fn.apply(new FieldValue.Builder()).build(), new FieldValue[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public QueryUser build() {
            this._checkSingleUse();
            return new QueryUser(this);
        }
    }
}

