/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.SimpleQueryStringFlag;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.UnionDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.ObjectBuilderBase;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class SimpleQueryStringFlags
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    public static final JsonpDeserializer<SimpleQueryStringFlags> _DESERIALIZER = JsonpDeserializer.lazy(SimpleQueryStringFlags::buildSimpleQueryStringFlagsDeserializer);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    private SimpleQueryStringFlags(Kind kind, Object value) {
        this._kind = kind;
        this._value = value;
    }

    public String _toJsonString() {
        switch (this._kind) {
            case Single: {
                return this.single().jsonValue();
            }
            case Multiple: {
                return this.multiple();
            }
        }
        throw new IllegalStateException("Unknown kind " + (Object)((Object)this._kind));
    }

    private SimpleQueryStringFlags(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
    }

    public static SimpleQueryStringFlags of(Function<Builder, ObjectBuilder<SimpleQueryStringFlags>> fn) {
        return fn.apply(new Builder()).build();
    }

    public boolean isSingle() {
        return this._kind == Kind.Single;
    }

    public SimpleQueryStringFlag single() {
        return (SimpleQueryStringFlag)TaggedUnionUtils.get(this, Kind.Single);
    }

    public boolean isMultiple() {
        return this._kind == Kind.Multiple;
    }

    public String multiple() {
        return (String)TaggedUnionUtils.get(this, Kind.Multiple);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        } else {
            switch (this._kind) {
                case Multiple: {
                    generator.write((String)this._value);
                }
            }
        }
    }

    private static JsonpDeserializer<SimpleQueryStringFlags> buildSimpleQueryStringFlagsDeserializer() {
        return new UnionDeserializer.Builder<SimpleQueryStringFlags, Kind, Object>(SimpleQueryStringFlags::new, true).addMember(Kind.Single, SimpleQueryStringFlag._DESERIALIZER).addMember(Kind.Multiple, JsonpDeserializer.stringDeserializer()).build();
    }

    public static class Builder
    extends ObjectBuilderBase
    implements ObjectBuilder<SimpleQueryStringFlags> {
        private Kind _kind;
        private Object _value;

        public ObjectBuilder<SimpleQueryStringFlags> single(SimpleQueryStringFlag v) {
            this._kind = Kind.Single;
            this._value = v;
            return this;
        }

        public ObjectBuilder<SimpleQueryStringFlags> multiple(String v) {
            this._kind = Kind.Multiple;
            this._value = v;
            return this;
        }

        @Override
        public SimpleQueryStringFlags build() {
            this._checkSingleUse();
            return new SimpleQueryStringFlags(this);
        }
    }

    public static enum Kind {
        Single,
        Multiple;

    }
}

