/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsStats;
import co.elastic.clients.elasticsearch.ml.DataframeAnalyticsStatsVariant;
import co.elastic.clients.elasticsearch.ml.Hyperparameters;
import co.elastic.clients.elasticsearch.ml.TimingStats;
import co.elastic.clients.elasticsearch.ml.ValidationLoss;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.DateTime;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class DataframeAnalyticsStatsHyperparameters
implements DataframeAnalyticsStatsVariant,
JsonpSerializable {
    private final Hyperparameters hyperparameters;
    private final int iteration;
    private final DateTime timestamp;
    private final TimingStats timingStats;
    private final ValidationLoss validationLoss;
    public static final JsonpDeserializer<DataframeAnalyticsStatsHyperparameters> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, DataframeAnalyticsStatsHyperparameters::setupDataframeAnalyticsStatsHyperparametersDeserializer);

    private DataframeAnalyticsStatsHyperparameters(Builder builder) {
        this.hyperparameters = ApiTypeHelper.requireNonNull(builder.hyperparameters, this, "hyperparameters");
        this.iteration = ApiTypeHelper.requireNonNull(builder.iteration, this, "iteration");
        this.timestamp = ApiTypeHelper.requireNonNull(builder.timestamp, this, "timestamp");
        this.timingStats = ApiTypeHelper.requireNonNull(builder.timingStats, this, "timingStats");
        this.validationLoss = ApiTypeHelper.requireNonNull(builder.validationLoss, this, "validationLoss");
    }

    public static DataframeAnalyticsStatsHyperparameters of(Function<Builder, ObjectBuilder<DataframeAnalyticsStatsHyperparameters>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public DataframeAnalyticsStats.Kind _dataframeAnalyticsStatsKind() {
        return DataframeAnalyticsStats.Kind.RegressionStats;
    }

    public final Hyperparameters hyperparameters() {
        return this.hyperparameters;
    }

    public final int iteration() {
        return this.iteration;
    }

    public final DateTime timestamp() {
        return this.timestamp;
    }

    public final TimingStats timingStats() {
        return this.timingStats;
    }

    public final ValidationLoss validationLoss() {
        return this.validationLoss;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("hyperparameters");
        this.hyperparameters.serialize(generator, mapper);
        generator.writeKey("iteration");
        generator.write(this.iteration);
        generator.writeKey("timestamp");
        this.timestamp.serialize(generator, mapper);
        generator.writeKey("timing_stats");
        this.timingStats.serialize(generator, mapper);
        generator.writeKey("validation_loss");
        this.validationLoss.serialize(generator, mapper);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupDataframeAnalyticsStatsHyperparametersDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::hyperparameters, Hyperparameters._DESERIALIZER, "hyperparameters");
        op.add(Builder::iteration, JsonpDeserializer.integerDeserializer(), "iteration");
        op.add(Builder::timestamp, DateTime._DESERIALIZER, "timestamp");
        op.add(Builder::timingStats, TimingStats._DESERIALIZER, "timing_stats");
        op.add(Builder::validationLoss, ValidationLoss._DESERIALIZER, "validation_loss");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<DataframeAnalyticsStatsHyperparameters> {
        private Hyperparameters hyperparameters;
        private Integer iteration;
        private DateTime timestamp;
        private TimingStats timingStats;
        private ValidationLoss validationLoss;

        public final Builder hyperparameters(Hyperparameters value) {
            this.hyperparameters = value;
            return this;
        }

        public final Builder hyperparameters(Function<Hyperparameters.Builder, ObjectBuilder<Hyperparameters>> fn) {
            return this.hyperparameters(fn.apply(new Hyperparameters.Builder()).build());
        }

        public final Builder iteration(int value) {
            this.iteration = value;
            return this;
        }

        public final Builder timestamp(DateTime value) {
            this.timestamp = value;
            return this;
        }

        public final Builder timingStats(TimingStats value) {
            this.timingStats = value;
            return this;
        }

        public final Builder timingStats(Function<TimingStats.Builder, ObjectBuilder<TimingStats>> fn) {
            return this.timingStats(fn.apply(new TimingStats.Builder()).build());
        }

        public final Builder validationLoss(ValidationLoss value) {
            this.validationLoss = value;
            return this;
        }

        public final Builder validationLoss(Function<ValidationLoss.Builder, ObjectBuilder<ValidationLoss>> fn) {
            return this.validationLoss(fn.apply(new ValidationLoss.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public DataframeAnalyticsStatsHyperparameters build() {
            this._checkSingleUse();
            return new DataframeAnalyticsStatsHyperparameters(this);
        }
    }
}

