/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.ChainEdge;
import com.agentsflex.core.chain.ChainNode;
import com.agentsflex.core.chain.ChainStatus;
import com.agentsflex.core.chain.NodeContext;
import com.agentsflex.core.chain.Parameter;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.DefaultJSONParser;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ChainHolder
implements Serializable {
    private String id;
    private String name;
    private String description;
    private List<ChainNode> nodes;
    private List<ChainEdge> edges;
    private Map<String, Object> executeResult;
    private Map<String, NodeContext> nodeContexts;
    private Map<String, ChainNode> suspendNodes = new ConcurrentHashMap<String, ChainNode>();
    private List<Parameter> suspendForParameters;
    private ChainStatus status;
    private Long computeCost;
    private int loopNodeExecutionLimit = 1000;
    private String message;

    public static ChainHolder fromChain(Chain chain) {
        ChainHolder holder = new ChainHolder();
        holder.id = chain.getId();
        holder.name = chain.getName();
        holder.description = chain.getDescription();
        holder.nodes = chain.getNodes();
        holder.edges = chain.getEdges();
        holder.executeResult = chain.getExecuteResult();
        holder.nodeContexts = chain.getNodeContexts();
        holder.suspendNodes = chain.getSuspendNodes();
        holder.suspendForParameters = chain.getSuspendForParameters();
        holder.status = chain.getStatus();
        holder.computeCost = chain.getComputeCost();
        holder.loopNodeExecutionLimit = chain.getLoopNodeExecutionLimit();
        holder.message = chain.getMessage();
        return holder;
    }

    public static ChainHolder fromJSON(String jsonString) {
        ParserConfig config = new ParserConfig();
        config.putDeserializer(Chain.class, (ObjectDeserializer)new ChainDeserializer());
        return (ChainHolder)JSON.parseObject((String)jsonString, ChainHolder.class, (ParserConfig)config, (Feature[])new Feature[]{Feature.SupportAutoType});
    }

    public String toJSON() {
        SerializeConfig config = new SerializeConfig();
        config.put(Chain.class, (ObjectSerializer)new ChainSerializer());
        return JSON.toJSONString((Object)this, (SerializeConfig)config, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteClassName});
    }

    public Chain toChain() {
        return new Chain(this);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<ChainNode> getNodes() {
        return this.nodes;
    }

    public void setNodes(List<ChainNode> nodes) {
        this.nodes = nodes;
    }

    public List<ChainEdge> getEdges() {
        return this.edges;
    }

    public void setEdges(List<ChainEdge> edges) {
        this.edges = edges;
    }

    public Map<String, Object> getExecuteResult() {
        return this.executeResult;
    }

    public void setExecuteResult(Map<String, Object> executeResult) {
        this.executeResult = executeResult;
    }

    public Map<String, NodeContext> getNodeContexts() {
        return this.nodeContexts;
    }

    public void setNodeContexts(Map<String, NodeContext> nodeContexts) {
        this.nodeContexts = nodeContexts;
    }

    public Map<String, ChainNode> getSuspendNodes() {
        return this.suspendNodes;
    }

    public void setSuspendNodes(Map<String, ChainNode> suspendNodes) {
        this.suspendNodes = suspendNodes;
    }

    public List<Parameter> getSuspendForParameters() {
        return this.suspendForParameters;
    }

    public void setSuspendForParameters(List<Parameter> suspendForParameters) {
        this.suspendForParameters = suspendForParameters;
    }

    public ChainStatus getStatus() {
        return this.status;
    }

    public void setStatus(ChainStatus status) {
        this.status = status;
    }

    public Long getComputeCost() {
        return this.computeCost;
    }

    public void setComputeCost(Long computeCost) {
        this.computeCost = computeCost;
    }

    public int getLoopNodeExecutionLimit() {
        return this.loopNodeExecutionLimit;
    }

    public void setLoopNodeExecutionLimit(int loopNodeExecutionLimit) {
        this.loopNodeExecutionLimit = loopNodeExecutionLimit;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String toString() {
        return "ChainHolder{id='" + this.id + '\'' + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", nodes=" + this.nodes + ", edges=" + this.edges + ", executeResult=" + this.executeResult + ", nodeContexts=" + this.nodeContexts + ", suspendNodes=" + this.suspendNodes + ", suspendForParameters=" + this.suspendForParameters + ", status=" + (Object)((Object)this.status) + ", computeCost=" + this.computeCost + ", loopNodeExecutionLimit=" + this.loopNodeExecutionLimit + ", message='" + this.message + '\'' + '}';
    }

    public static class ChainDeserializer
    implements ObjectDeserializer {
        public <T> T deserialze(DefaultJSONParser parser, Type type, Object fieldName) {
            String value = (String)parser.parseObject(String.class);
            return (T)Chain.fromJSON(value);
        }
    }

    public static class ChainSerializer
    implements ObjectSerializer {
        public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
            if (object == null) {
                serializer.writeNull();
                return;
            }
            Chain chain = (Chain)object;
            serializer.write(chain.toJSON());
        }
    }
}

