/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.chain;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.chain.ChainEdge;
import com.agentsflex.core.chain.ChainNodeStatus;
import com.agentsflex.core.chain.ChainNodeValidResult;
import com.agentsflex.core.chain.ChainNodeValidator;
import com.agentsflex.core.chain.NodeCondition;
import com.agentsflex.core.chain.Parameter;
import com.agentsflex.core.memory.ContextMemory;
import com.agentsflex.core.memory.DefaultContextMemory;
import com.agentsflex.core.util.JsConditionUtil;
import com.agentsflex.core.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChainNode
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(ChainNode.class);
    protected String id;
    protected String name;
    protected String description;
    protected boolean async = false;
    protected List<ChainEdge> inwardEdges;
    protected List<ChainEdge> outwardEdges;
    protected NodeCondition condition;
    protected ContextMemory memory = new DefaultContextMemory();
    protected ChainNodeStatus nodeStatus = ChainNodeStatus.READY;
    protected ChainNodeValidator validator;
    protected boolean loopEnable = false;
    protected long loopIntervalMs = 1000L;
    protected NodeCondition loopBreakCondition;
    protected int maxLoopCount = 0;
    protected Long computeCost;
    protected String computeCostExpr;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isAsync() {
        return this.async;
    }

    public void setAsync(boolean async) {
        this.async = async;
    }

    public List<ChainEdge> getInwardEdges() {
        return this.inwardEdges;
    }

    public void setInwardEdges(List<ChainEdge> inwardEdges) {
        this.inwardEdges = inwardEdges;
    }

    public List<ChainEdge> getOutwardEdges() {
        return this.outwardEdges;
    }

    public void setOutwardEdges(List<ChainEdge> outwardEdges) {
        this.outwardEdges = outwardEdges;
    }

    public NodeCondition getCondition() {
        return this.condition;
    }

    public void setCondition(NodeCondition condition) {
        this.condition = condition;
    }

    public ContextMemory getMemory() {
        return this.memory;
    }

    public void setMemory(ContextMemory memory) {
        this.memory = memory;
    }

    public ChainNodeStatus getNodeStatus() {
        return this.nodeStatus;
    }

    public void setNodeStatus(ChainNodeStatus nodeStatus) {
        this.nodeStatus = nodeStatus;
    }

    public void setNodeStatusFinished() {
        if (this.nodeStatus == ChainNodeStatus.ERROR) {
            this.setNodeStatus(ChainNodeStatus.FINISHED_ABNORMAL);
        } else {
            this.setNodeStatus(ChainNodeStatus.FINISHED_NORMAL);
        }
    }

    public ChainNodeValidator getValidator() {
        return this.validator;
    }

    public void setValidator(ChainNodeValidator validator) {
        this.validator = validator;
    }

    protected void addOutwardEdge(ChainEdge edge) {
        if (this.outwardEdges == null) {
            this.outwardEdges = new ArrayList<ChainEdge>();
        }
        this.outwardEdges.add(edge);
    }

    protected void addInwardEdge(ChainEdge edge) {
        if (this.inwardEdges == null) {
            this.inwardEdges = new ArrayList<ChainEdge>();
        }
        this.inwardEdges.add(edge);
    }

    public boolean isLoopEnable() {
        return this.loopEnable;
    }

    public void setLoopEnable(boolean loopEnable) {
        this.loopEnable = loopEnable;
    }

    public long getLoopIntervalMs() {
        return this.loopIntervalMs;
    }

    public void setLoopIntervalMs(long loopIntervalMs) {
        this.loopIntervalMs = loopIntervalMs;
    }

    public NodeCondition getLoopBreakCondition() {
        return this.loopBreakCondition;
    }

    public void setLoopBreakCondition(NodeCondition loopBreakCondition) {
        this.loopBreakCondition = loopBreakCondition;
    }

    public int getMaxLoopCount() {
        return this.maxLoopCount;
    }

    public void setMaxLoopCount(int maxLoopCount) {
        this.maxLoopCount = maxLoopCount;
    }

    public List<Parameter> getParameters() {
        return null;
    }

    public Long getComputeCost() {
        return this.computeCost;
    }

    public void setComputeCost(Long computeCost) {
        this.computeCost = computeCost;
    }

    protected synchronized void addComputeCost(Long computeCost) {
        if (this.computeCost == null) {
            this.computeCost = 0L;
        }
        if (computeCost == null) {
            computeCost = 0L;
        }
        ChainNode chainNode = this;
        chainNode.computeCost = chainNode.computeCost + computeCost;
    }

    public String getComputeCostExpr() {
        return this.computeCostExpr;
    }

    public void setComputeCostExpr(String computeCostExpr) {
        if (computeCostExpr != null) {
            computeCostExpr = computeCostExpr.trim();
        }
        this.computeCostExpr = computeCostExpr;
    }

    public long calculateComputeCost(Chain chain, Map<String, Object> result) {
        if (this.computeCost != null) {
            return this.computeCost;
        }
        if (StringUtil.noText(this.computeCostExpr)) {
            return 0L;
        }
        if (this.computeCostExpr.startsWith("{{") && this.computeCostExpr.endsWith("}}")) {
            String expr = this.computeCostExpr.substring(2, this.computeCostExpr.length() - 2);
            return this.doCalculateComputeCost(expr, chain, result);
        }
        try {
            return Long.parseLong(this.computeCostExpr);
        }
        catch (NumberFormatException e) {
            log.error(e.toString(), (Throwable)e);
            return 0L;
        }
    }

    protected long doCalculateComputeCost(String expr, Chain chain, Map<String, Object> result) {
        Map<String, Object> parameterValues = chain.getParameterValuesOnly(this, this.getParameters(), null);
        HashMap<String, Object> newMap = new HashMap<String, Object>(result);
        newMap.putAll(parameterValues);
        return JsConditionUtil.evalLong(expr, chain, newMap);
    }

    public ChainNodeValidResult validate() throws Exception {
        return this.validator != null ? this.validator.validate(this) : ChainNodeValidResult.ok();
    }

    protected abstract Map<String, Object> execute(Chain var1);
}

