/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.llm.client;

import com.agentsflex.core.util.StringUtil;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.concurrent.TimeUnit;
import okhttp3.ConnectionPool;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpClientUtil {
    private static final Logger log = LoggerFactory.getLogger(OkHttpClientUtil.class);
    private static final String PREFIX = "okhttp.";
    private static final String ENV_PREFIX = "OKHTTP_";
    private static volatile OkHttpClient defaultClient;
    private static volatile OkHttpClient.Builder customBuilder;

    public static void setOkHttpClientBuilder(OkHttpClient.Builder builder) {
        if (defaultClient != null) {
            throw new IllegalStateException("OkHttpClient has already been initialized. Please set the builder before first usage.");
        }
        customBuilder = builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static OkHttpClient buildDefaultClient() {
        if (defaultClient != null) return defaultClient;
        Class<OkHttpClientUtil> clazz = OkHttpClientUtil.class;
        synchronized (OkHttpClientUtil.class) {
            if (defaultClient != null) return defaultClient;
            OkHttpClient.Builder builder = customBuilder != null ? customBuilder : OkHttpClientUtil.createDefaultBuilder();
            defaultClient = builder.build();
            log.debug("OkHttpClient initialized with config: connectTimeout={}s, readTimeout={}s, writeTimeout={}s, connectionPool(maxIdle={}, keepAlive={}min)", new Object[]{OkHttpClientUtil.getConnectTimeout(), OkHttpClientUtil.getReadTimeout(), OkHttpClientUtil.getWriteTimeout(), OkHttpClientUtil.getMaxIdleConnections(), OkHttpClientUtil.getKeepAliveMinutes()});
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultClient;
        }
    }

    private static OkHttpClient.Builder createDefaultBuilder() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder().connectTimeout((long)OkHttpClientUtil.getConnectTimeout(), TimeUnit.SECONDS).readTimeout((long)OkHttpClientUtil.getReadTimeout(), TimeUnit.SECONDS).writeTimeout((long)OkHttpClientUtil.getWriteTimeout(), TimeUnit.SECONDS).connectionPool(new ConnectionPool(OkHttpClientUtil.getMaxIdleConnections(), OkHttpClientUtil.getKeepAliveMinutes(), TimeUnit.MINUTES));
        OkHttpClientUtil.configureProxy(builder);
        return builder;
    }

    private static int getConnectTimeout() {
        return OkHttpClientUtil.getIntConfig("connectTimeout", "CONNECT_TIMEOUT", 60);
    }

    private static int getReadTimeout() {
        return OkHttpClientUtil.getIntConfig("readTimeout", "READ_TIMEOUT", 300);
    }

    private static int getWriteTimeout() {
        return OkHttpClientUtil.getIntConfig("writeTimeout", "WRITE_TIMEOUT", 60);
    }

    private static int getMaxIdleConnections() {
        return OkHttpClientUtil.getIntConfig("connectionPool.maxIdleConnections", "CONNECTION_POOL_MAX_IDLE_CONNECTIONS", 5);
    }

    private static long getKeepAliveMinutes() {
        return OkHttpClientUtil.getLongConfig("connectionPool.keepAliveMinutes", "CONNECTION_POOL_KEEP_ALIVE_MINUTES", 10L);
    }

    private static String getProxyHost() {
        String host = OkHttpClientUtil.getPropertyOrEnv("proxy.host", "PROXY_HOST", null);
        if (StringUtil.hasText(host)) {
            return host.trim();
        }
        host = System.getProperty("https.proxyHost");
        if (StringUtil.hasText(host)) {
            return host.trim();
        }
        host = System.getProperty("http.proxyHost");
        if (StringUtil.hasText(host)) {
            return host.trim();
        }
        return null;
    }

    private static String getProxyPort() {
        String port = OkHttpClientUtil.getPropertyOrEnv("proxy.port", "PROXY_PORT", null);
        if (StringUtil.hasText(port)) {
            return port.trim();
        }
        port = System.getProperty("https.proxyPort");
        if (StringUtil.hasText(port)) {
            return port.trim();
        }
        port = System.getProperty("http.proxyPort");
        if (StringUtil.hasText(port)) {
            return port.trim();
        }
        return null;
    }

    private static int getIntConfig(String sysPropKey, String envKey, int defaultValue) {
        String value = OkHttpClientUtil.getPropertyOrEnv(sysPropKey, envKey, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException e) {
            log.warn("Invalid integer value for '{}': '{}'. Using default: {}", new Object[]{OkHttpClientUtil.fullSysPropKey(sysPropKey), value, defaultValue});
            return defaultValue;
        }
    }

    private static long getLongConfig(String sysPropKey, String envKey, long defaultValue) {
        String value = OkHttpClientUtil.getPropertyOrEnv(sysPropKey, envKey, null);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value.trim());
        }
        catch (NumberFormatException e) {
            log.warn("Invalid long value for '{}': '{}'. Using default: {}", new Object[]{OkHttpClientUtil.fullSysPropKey(sysPropKey), value, defaultValue});
            return defaultValue;
        }
    }

    private static String getPropertyOrEnv(String sysPropKey, String envKey, String defaultValue) {
        String value = System.getProperty(OkHttpClientUtil.fullSysPropKey(sysPropKey));
        if (value != null) {
            return value;
        }
        value = System.getenv(ENV_PREFIX + envKey);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    private static String fullSysPropKey(String key) {
        return PREFIX + key;
    }

    private static void configureProxy(OkHttpClient.Builder builder) {
        String proxyHost = OkHttpClientUtil.getProxyHost();
        String proxyPort = OkHttpClientUtil.getProxyPort();
        if (StringUtil.hasText(proxyHost) && StringUtil.hasText(proxyPort)) {
            try {
                int port = Integer.parseInt(proxyPort);
                InetSocketAddress address = new InetSocketAddress(proxyHost, port);
                builder.proxy(new Proxy(Proxy.Type.HTTP, address));
                log.debug("HTTP proxy configured via config: {}:{}", (Object)proxyHost, (Object)port);
            }
            catch (NumberFormatException e) {
                log.warn("Invalid proxy port '{}'. Proxy will be ignored.", (Object)proxyPort, (Object)e);
            }
        }
    }
}

