/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.llm.client.impl;

import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.client.OkHttpClientUtil;
import com.agentsflex.core.llm.client.impl.Util;
import com.agentsflex.core.util.LogUtil;
import com.agentsflex.core.util.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

public class DnjsonClient
implements LlmClient,
Callback {
    private static final MediaType JSON_TYPE = MediaType.parse((String)"application/json; charset=utf-8");
    private OkHttpClient okHttpClient;
    private LlmClientListener listener;
    private LlmConfig config;
    private boolean isStop = false;

    public DnjsonClient() {
        this(OkHttpClientUtil.buildDefaultClient());
    }

    public DnjsonClient(OkHttpClient okHttpClient) {
        if (okHttpClient == null) {
            throw new IllegalArgumentException("OkHttpClient must not be null");
        }
        this.okHttpClient = okHttpClient;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public void setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    @Override
    public void start(String url, Map<String, String> headers, String payload, LlmClientListener listener, LlmConfig config) {
        if (this.isStop) {
            throw new IllegalStateException("DnjsonClient has been stopped and cannot be reused.");
        }
        this.listener = listener;
        this.config = config;
        this.isStop = false;
        Request.Builder builder = new Request.Builder().url(url);
        if (headers != null && !headers.isEmpty()) {
            headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        }
        RequestBody body = RequestBody.create((String)payload, (MediaType)JSON_TYPE);
        Request request = builder.post(body).build();
        if (config != null && config.isDebug()) {
            LogUtil.println(">>>> send payload: {}", payload);
        }
        if (this.listener != null) {
            try {
                this.listener.onStart(this);
            }
            catch (Exception e) {
                LogUtil.warn("Error in listener.onStart", e);
                return;
            }
        }
        this.okHttpClient.newCall(request).enqueue((Callback)this);
    }

    @Override
    public void stop() {
        this.markAsStopped();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(@NotNull Call call, @NotNull IOException e) {
        try {
            if (this.listener != null && !this.isStop) {
                Throwable error = Util.getFailureThrowable(e, null);
                this.listener.onFailure(this, error);
            }
        }
        catch (Exception ex) {
            LogUtil.warn("Error in listener.onFailure", ex);
        }
        finally {
            this.markAsStopped();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
        block37: {
            try {
                if (!response.isSuccessful()) {
                    if (this.listener != null && !this.isStop) {
                        Throwable error = Util.getFailureThrowable(null, response);
                        this.listener.onFailure(this, error);
                    }
                    return;
                }
                ResponseBody body = response.body();
                if (body == null || this.isStop) {
                    return;
                }
                try (ResponseBody responseBody = body;){
                    BufferedReader reader = new BufferedReader(new InputStreamReader(responseBody.byteStream()));
                    Throwable throwable = null;
                    block25: while (true) {
                        try {
                            String line;
                            while ((line = reader.readLine()) != null) {
                                String jsonLine;
                                if (this.isStop) {
                                    break block37;
                                }
                                if (!StringUtil.hasText(line)) continue;
                                String string = jsonLine = StringUtil.isJsonObject(line) ? line : "{" + line + "}";
                                if (this.listener == null || this.isStop) continue;
                                try {
                                    this.listener.onMessage(this, jsonLine);
                                    continue block25;
                                }
                                catch (Exception e) {
                                    LogUtil.warn("Error in listener.onMessage", e);
                                }
                            }
                            break block37;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                    finally {
                        if (reader != null) {
                            if (throwable != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                            } else {
                                reader.close();
                            }
                        }
                    }
                }
            }
            finally {
                this.markAsStopped();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markAsStopped() {
        if (this.isStop) {
            return;
        }
        DnjsonClient dnjsonClient = this;
        synchronized (dnjsonClient) {
            if (this.isStop) {
                return;
            }
            this.isStop = true;
            if (this.listener != null) {
                try {
                    this.listener.onStop(this);
                }
                catch (Exception e) {
                    LogUtil.warn("Error in listener.onStop", e);
                }
            }
        }
    }
}

