/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.llm.client.impl;

import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.client.OkHttpClientUtil;
import com.agentsflex.core.llm.client.impl.Util;
import com.agentsflex.core.util.LogUtil;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;

public class WebSocketClient
extends WebSocketListener
implements LlmClient {
    private OkHttpClient okHttpClient;
    private WebSocket webSocket;
    private LlmClientListener listener;
    private LlmConfig config;
    private boolean isStop = false;
    private String payload;

    public WebSocketClient() {
        this(OkHttpClientUtil.buildDefaultClient());
    }

    public WebSocketClient(OkHttpClient okHttpClient) {
        if (okHttpClient == null) {
            throw new IllegalArgumentException("OkHttpClient must not be null");
        }
        this.okHttpClient = okHttpClient;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public void setOkHttpClient(OkHttpClient okHttpClient) {
        this.okHttpClient = okHttpClient;
    }

    @Override
    public void start(String url, Map<String, String> headers, String payload, LlmClientListener listener, LlmConfig config) {
        if (this.isStop) {
            throw new IllegalStateException("WebSocketClient has been stopped and cannot be reused.");
        }
        this.listener = listener;
        this.payload = payload;
        this.config = config;
        this.isStop = false;
        Request.Builder builder = new Request.Builder().url(url);
        if (headers != null && !headers.isEmpty()) {
            headers.forEach((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        }
        Request request = builder.build();
        this.webSocket = this.okHttpClient.newWebSocket(request, (WebSocketListener)this);
        if (config != null && config.isDebug()) {
            LogUtil.println(">>>>send payload:" + payload);
        }
    }

    @Override
    public void stop() {
        this.closeWebSocketAndNotify();
    }

    public void onOpen(WebSocket webSocket, Response response) {
        webSocket.send(this.payload);
        this.listener.onStart(this);
    }

    public void onMessage(WebSocket webSocket, String text) {
        if (this.config.isDebug()) {
            LogUtil.println(">>>>receive payload:" + text);
        }
        this.listener.onMessage(this, text);
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        this.onMessage(webSocket, bytes.utf8());
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        this.closeWebSocketAndNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        try {
            Throwable failureThrowable = Util.getFailureThrowable(t, response);
            this.listener.onFailure(this, failureThrowable);
        }
        finally {
            this.closeWebSocketAndNotify();
        }
    }

    public void onClosed(@NotNull WebSocket webSocket, int code, @NotNull String reason) {
        this.closeWebSocketAndNotify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeWebSocketAndNotify() {
        if (this.isStop) {
            return;
        }
        WebSocketClient webSocketClient = this;
        synchronized (webSocketClient) {
            if (this.isStop) {
                return;
            }
            this.isStop = true;
            if (this.listener != null) {
                try {
                    this.listener.onStop(this);
                }
                catch (Exception e) {
                    LogUtil.warn(e.getMessage(), e);
                }
            }
            if (this.webSocket != null) {
                try {
                    this.webSocket.close(1000, "");
                }
                catch (Exception exception) {
                }
                finally {
                    this.webSocket = null;
                }
            }
        }
    }
}

