/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.message;

import com.agentsflex.core.message.HumanMessage;
import com.agentsflex.core.prompt.AudioPrompt;
import com.agentsflex.core.util.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HumanAudioMessage
extends HumanMessage {
    private final AudioPrompt prompt;

    public HumanAudioMessage(AudioPrompt prompt) {
        this.prompt = prompt;
    }

    public AudioPrompt getPrompt() {
        return this.prompt;
    }

    @Override
    public Object getMessageContent() {
        ArrayList<Map<String, Object>> messageContent = new ArrayList<Map<String, Object>>();
        messageContent.add(Maps.of("type", "text").set("text", this.prompt.getContent()));
        messageContent.addAll(this.buildAudioContent());
        return messageContent;
    }

    public List<Map<String, Object>> buildAudioContent() {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(1);
        List<String> audioUrls = this.prompt.getAudioUrls();
        if (audioUrls != null) {
            for (String url : audioUrls) {
                result.add(Maps.of("type", "audio_url").set("audio_url", Maps.of("url", url)));
            }
        }
        return result;
    }
}

