/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.message;

import com.agentsflex.core.message.HumanMessage;
import com.agentsflex.core.prompt.ImagePrompt;
import com.agentsflex.core.util.Maps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class HumanImageMessage
extends HumanMessage {
    private final ImagePrompt prompt;

    public HumanImageMessage(ImagePrompt prompt) {
        this.prompt = prompt;
    }

    public ImagePrompt getPrompt() {
        return this.prompt;
    }

    @Override
    public Object getMessageContent() {
        ArrayList<Map<String, Object>> messageContent = new ArrayList<Map<String, Object>>();
        messageContent.add(Maps.of("type", "text").set("text", this.prompt.getContent()));
        messageContent.addAll(this.buildImageContent());
        return messageContent;
    }

    public List<Map<String, Object>> buildImageContent() {
        List<String> imageBase64s;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(1);
        List<String> imageUrls = this.prompt.getImageUrls();
        if (imageUrls != null) {
            for (String url : imageUrls) {
                result.add(Maps.of("type", "image_url").set("image_url", Maps.of("url", url)));
            }
        }
        if ((imageBase64s = this.prompt.getImageBase64s()) != null) {
            for (String base64 : imageBase64s) {
                result.add(Maps.of("type", "image_url").set("image_url", Maps.of("url", base64)));
            }
        }
        return result;
    }
}

