/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.prompt;

import com.agentsflex.core.memory.ChatMemory;
import com.agentsflex.core.memory.DefaultChatMemory;
import com.agentsflex.core.message.AbstractTextMessage;
import com.agentsflex.core.message.Message;
import com.agentsflex.core.message.SystemMessage;
import com.agentsflex.core.prompt.Prompt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;

public class HistoriesPrompt
extends Prompt {
    private ChatMemory memory = new DefaultChatMemory();
    private SystemMessage systemMessage;
    private int maxAttachedMessageCount = 10;
    private boolean historyMessageTruncateEnable = false;
    private int historyMessageTruncateLength = 1000;
    private Function<String, String> historyMessageTruncateProcessor;
    private List<Message> temporaryMessages;

    public SystemMessage getSystemMessage() {
        return this.systemMessage;
    }

    public void setSystemMessage(SystemMessage systemMessage) {
        this.systemMessage = systemMessage;
    }

    public int getMaxAttachedMessageCount() {
        return this.maxAttachedMessageCount;
    }

    public void setMaxAttachedMessageCount(int maxAttachedMessageCount) {
        this.maxAttachedMessageCount = maxAttachedMessageCount;
    }

    public boolean isHistoryMessageTruncateEnable() {
        return this.historyMessageTruncateEnable;
    }

    public void setHistoryMessageTruncateEnable(boolean historyMessageTruncateEnable) {
        this.historyMessageTruncateEnable = historyMessageTruncateEnable;
    }

    public int getHistoryMessageTruncateLength() {
        return this.historyMessageTruncateLength;
    }

    public void setHistoryMessageTruncateLength(int historyMessageTruncateLength) {
        this.historyMessageTruncateLength = historyMessageTruncateLength;
    }

    public Function<String, String> getHistoryMessageTruncateProcessor() {
        return this.historyMessageTruncateProcessor;
    }

    public void setHistoryMessageTruncateProcessor(Function<String, String> historyMessageTruncateProcessor) {
        this.historyMessageTruncateProcessor = historyMessageTruncateProcessor;
    }

    public HistoriesPrompt() {
    }

    public HistoriesPrompt(ChatMemory memory) {
        this.memory = memory;
    }

    public void addMessage(Message message) {
        this.memory.addMessage(message);
    }

    public void addMessageTemporary(Message message) {
        if (this.temporaryMessages == null) {
            this.temporaryMessages = new ArrayList<Message>();
        }
        this.temporaryMessages.add(message);
    }

    public void addMessages(Collection<Message> messages) {
        this.memory.addMessages(messages);
    }

    public ChatMemory getMemory() {
        return this.memory;
    }

    public void setMemory(ChatMemory memory) {
        this.memory = memory;
    }

    public List<Message> getTemporaryMessages() {
        return this.temporaryMessages;
    }

    public void setTemporaryMessages(List<Message> temporaryMessages) {
        this.temporaryMessages = temporaryMessages;
    }

    public void clearTemporaryMessages() {
        this.temporaryMessages.clear();
        this.temporaryMessages = null;
    }

    @Override
    public List<Message> toMessages() {
        Message firstMessage;
        List<Message> messages = this.memory.getMessages();
        if (messages == null) {
            messages = new ArrayList<Message>();
        }
        if (messages.size() > this.maxAttachedMessageCount) {
            messages = new ArrayList<Message>(messages.subList(messages.size() - this.maxAttachedMessageCount, messages.size()));
        }
        if (this.historyMessageTruncateEnable) {
            for (Message message : messages) {
                if (!(message instanceof AbstractTextMessage)) continue;
                String content = ((AbstractTextMessage)message).getContent();
                if (this.historyMessageTruncateProcessor != null) {
                    content = this.historyMessageTruncateProcessor.apply(content);
                } else if (content.length() > this.historyMessageTruncateLength) {
                    content = content.substring(0, this.historyMessageTruncateLength);
                }
                ((AbstractTextMessage)message).setContent(content);
            }
        }
        if (!((firstMessage = messages.get(0)) instanceof SystemMessage) && this.systemMessage != null) {
            messages.add(0, this.systemMessage);
        }
        if (this.temporaryMessages != null) {
            messages.addAll(this.temporaryMessages);
        }
        return messages;
    }
}

