/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.prompt;

import com.agentsflex.core.message.HumanImageMessage;
import com.agentsflex.core.message.Message;
import com.agentsflex.core.prompt.TextPrompt;
import com.agentsflex.core.util.ImageUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class ImagePrompt
extends TextPrompt {
    private List<String> imageUrls;
    private List<String> imageBase64s;

    public ImagePrompt(String content) {
        super(content);
    }

    public ImagePrompt(String content, String imageUrl) {
        super(content);
        this.imageUrls = new ArrayList<String>(1);
        this.imageUrls.add(imageUrl);
    }

    public ImagePrompt(String content, File imageFile) {
        super(content);
        this.imageBase64s = new ArrayList<String>(1);
        this.imageBase64s.add(ImageUtil.imageFileToDataUri(imageFile));
    }

    public ImagePrompt(TextPrompt textPrompt) {
        super(textPrompt.getContent());
        this.setSystemMessage(textPrompt.getSystemMessage());
    }

    public ImagePrompt(TextPrompt textPrompt, String imageUrl) {
        super(textPrompt.getContent());
        this.setSystemMessage(textPrompt.getSystemMessage());
        this.imageUrls = new ArrayList<String>(1);
        this.imageUrls.add(imageUrl);
    }

    public ImagePrompt(TextPrompt textPrompt, Collection<String> imageUrls) {
        super(textPrompt.getContent());
        this.setSystemMessage(textPrompt.getSystemMessage());
        this.imageUrls = new ArrayList<String>(imageUrls.size());
        this.imageUrls.addAll(imageUrls);
    }

    public List<String> getImageUrls() {
        return this.imageUrls;
    }

    public void setImageUrls(List<String> imageUrls) {
        this.imageUrls = imageUrls;
    }

    public void addImageUrl(String imageUrl) {
        if (this.imageUrls == null) {
            this.imageUrls = new ArrayList<String>(1);
        }
        this.imageUrls.add(imageUrl);
    }

    public void addImageFile(File imageFile) {
        this.addImageBase64(ImageUtil.imageFileToDataUri(imageFile));
    }

    public List<String> getImageBase64s() {
        return this.imageBase64s;
    }

    public void setImageBase64s(List<String> imageBase64s) {
        this.imageBase64s = imageBase64s;
    }

    public void addImageBase64(String imageBase64) {
        if (this.imageBase64s == null) {
            this.imageBase64s = new ArrayList<String>(1);
        }
        this.imageBase64s.add(imageBase64);
    }

    public List<String> buildAllToBase64s() {
        ArrayList<String> allBase64s = new ArrayList<String>();
        if (this.imageUrls != null) {
            for (String imageUrl : this.imageUrls) {
                allBase64s.add(ImageUtil.imageUrlToDataUri(imageUrl));
            }
        }
        if (this.imageBase64s != null) {
            allBase64s.addAll(this.imageBase64s);
        }
        return allBase64s;
    }

    @Override
    public List<Message> toMessages() {
        return Collections.singletonList(new HumanImageMessage(this));
    }

    @Override
    public String toString() {
        return "ImagePrompt{imageUrls=" + this.imageUrls + ", imageBase64s=" + this.imageBase64s + '}';
    }
}

