/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.util;

import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.util.IOUtil;
import java.io.File;
import java.net.URLConnection;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class ImageUtil {
    private static final HttpClient imageHttpClient = new HttpClient();
    private static final Map<String, String> EXTENSION_TO_MIME = new ConcurrentHashMap<String, String>();

    public static String imageUrlToDataUri(String imageUrl) {
        Objects.requireNonNull(imageUrl, "Image URL must not be null");
        try {
            byte[] bytes = imageHttpClient.getBytes(imageUrl);
            String mimeType = ImageUtil.guessMimeTypeFromName(imageUrl);
            return ImageUtil.toDataUri(bytes, mimeType);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to convert image URL to Data URI: " + imageUrl, e);
        }
    }

    public static String imageFileToDataUri(File imageFile) {
        Objects.requireNonNull(imageFile, "Image file must not be null");
        byte[] bytes = IOUtil.readBytes(imageFile);
        String mimeType = ImageUtil.guessMimeTypeFromName(imageFile.getName());
        return ImageUtil.toDataUri(bytes, mimeType);
    }

    private static String guessMimeTypeFromName(String name) {
        if (name == null || name.isEmpty()) {
            return "image/jpeg";
        }
        int lastDotIndex = name.lastIndexOf(46);
        if (lastDotIndex == -1 || lastDotIndex == name.length() - 1) {
            String mime = URLConnection.guessContentTypeFromName(name);
            return mime != null ? mime : "image/jpeg";
        }
        String ext = name.substring(lastDotIndex + 1).toLowerCase(Locale.ROOT);
        String mime = EXTENSION_TO_MIME.get(ext);
        if (mime != null) {
            return mime;
        }
        mime = URLConnection.guessContentTypeFromName(name);
        return mime != null ? mime : "image/jpeg";
    }

    private static String toDataUri(byte[] data, String mimeType) {
        String base64 = Base64.getEncoder().encodeToString(data);
        return mimeType + ";base64," + base64;
    }

    static {
        EXTENSION_TO_MIME.put("jpg", "image/jpeg");
        EXTENSION_TO_MIME.put("jpeg", "image/jpeg");
        EXTENSION_TO_MIME.put("png", "image/png");
        EXTENSION_TO_MIME.put("gif", "image/gif");
        EXTENSION_TO_MIME.put("bmp", "image/bmp");
        EXTENSION_TO_MIME.put("svg", "image/svg+xml");
        EXTENSION_TO_MIME.put("webp", "image/webp");
        EXTENSION_TO_MIME.put("avif", "image/avif");
        EXTENSION_TO_MIME.put("jxl", "image/jxl");
        EXTENSION_TO_MIME.put("tiff", "image/tiff");
        EXTENSION_TO_MIME.put("tif", "image/tiff");
        EXTENSION_TO_MIME.put("ico", "image/x-icon");
    }
}

