/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.util;

import com.agentsflex.core.chain.Chain;
import com.agentsflex.core.util.graalvm.JsInteropUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.Value;

public class JsConditionUtil {
    private static final Context.Builder CONTEXT_BUILDER = Context.newBuilder((String[])new String[]{"js"}).option("engine.WarnInterpreterOnly", "false").allowHostAccess(HostAccess.ALL).allowHostClassLookup(className -> false).option("js.ecmascript-version", "2021");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean eval(String code, Chain chain, Map<String, Object> initMap) {
        try (Context context = CONTEXT_BUILDER.build();){
            HashMap _result = new HashMap();
            Value bindings = context.getBindings("js");
            Map<String, Object> contextVariables = JsConditionUtil.collectContextVariables(chain, initMap);
            contextVariables.forEach((key, value) -> bindings.putMember(key, (Object)JsInteropUtils.wrapJavaValueForJS(context, value)));
            bindings.putMember("_result", _result);
            code = "_result.value = " + code;
            context.eval("js", (CharSequence)code);
            Object value2 = _result.get("value");
            boolean bl = JsConditionUtil.toBoolean(value2);
            return bl;
        }
        catch (Exception e) {
            throw new RuntimeException("JavaScript \u6267\u884c\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long evalLong(String code, Chain chain, Map<String, Object> initMap) {
        try (Context context = CONTEXT_BUILDER.build();){
            HashMap _result = new HashMap();
            Value bindings = context.getBindings("js");
            Map<String, Object> contextVariables = JsConditionUtil.collectContextVariables(chain, initMap);
            contextVariables.forEach((key, value) -> bindings.putMember(key, (Object)JsInteropUtils.wrapJavaValueForJS(context, value)));
            bindings.putMember("_result", _result);
            code = "_result.value = " + code;
            context.eval("js", (CharSequence)code);
            Object value2 = _result.get("value");
            long l = JsConditionUtil.toLong(value2);
            return l;
        }
        catch (Exception e) {
            throw new RuntimeException("JavaScript \u6267\u884c\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private static long toLong(Object value) {
        if (value == null) {
            return 0L;
        }
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof String) {
            String str = ((String)value).trim();
            if (str.isEmpty()) {
                return 0L;
            }
            try {
                return Double.valueOf(str).longValue();
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("\u65e0\u6cd5\u5c06\u5b57\u7b26\u4e32 \"" + str + "\" \u8f6c\u6362\u4e3a long", e);
            }
        }
        if (value instanceof Value) {
            Value v = (Value)value;
            if (v.isNumber()) {
                return v.asLong();
            }
            if (v.isString()) {
                return JsConditionUtil.toLong(v.asString());
            }
            if (v.isNull()) {
                return 0L;
            }
            throw new RuntimeException("\u65e0\u6cd5\u5c06 JS \u503c " + v + " \u8f6c\u6362\u4e3a long");
        }
        try {
            String str = value.toString().trim();
            return str.isEmpty() ? 0L : Double.valueOf(str).longValue();
        }
        catch (Exception e) {
            throw new RuntimeException("\u65e0\u6cd5\u5c06\u5bf9\u8c61 " + value + " \u8f6c\u6362\u4e3a long", e);
        }
    }

    private static Map<String, Object> collectContextVariables(Chain chain, Map<String, Object> initMap) {
        ConcurrentHashMap<String, Object> variables = new ConcurrentHashMap<String, Object>();
        chain.getMemory().getAll().forEach((key, value) -> {
            int dotIndex = key.indexOf(".");
            String varName = dotIndex >= 0 ? key.substring(dotIndex + 1) : key;
            variables.put(varName, value);
        });
        variables.putAll(initMap);
        return variables;
    }

    private static boolean toBoolean(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return ((Number)value).intValue() != 0;
        }
        if (value instanceof String) {
            String str = ((String)value).trim().toLowerCase();
            return !str.isEmpty() && !"0".equals(str) && !"false".equals(str);
        }
        if (value instanceof Value) {
            Value v = (Value)value;
            if (v.isBoolean()) {
                return v.asBoolean();
            }
            if (v.isNumber()) {
                return v.asDouble() != 0.0;
            }
            if (v.isString()) {
                String str = v.asString().trim().toLowerCase();
                return !str.isEmpty() && !"0".equals(str) && !"false".equals(str);
            }
            return !v.isNull();
        }
        return true;
    }
}

