/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.core.util;

import java.util.Collection;

public class TernaryExpr {
    final String condition;
    final String trueExpr;
    final String falseExpr;

    public TernaryExpr(String condition, String trueExpr, String falseExpr) {
        this.condition = condition.trim();
        this.trueExpr = trueExpr.trim();
        this.falseExpr = falseExpr.trim();
    }

    public static TernaryExpr of(String key) {
        int questionIndex = -1;
        int colonIndex = -1;
        for (int i = 0; i < key.length(); ++i) {
            char c = key.charAt(i);
            if (c == '?') {
                if (questionIndex != -1) continue;
                questionIndex = i;
                continue;
            }
            if (c != ':' || questionIndex == -1) continue;
            colonIndex = i;
            break;
        }
        if (questionIndex > 0 && colonIndex > questionIndex + 1) {
            String condition = key.substring(0, questionIndex);
            String truePart = key.substring(questionIndex + 1, colonIndex);
            String falsePart = key.substring(colonIndex + 1);
            return new TernaryExpr(condition, truePart, falsePart);
        }
        return null;
    }

    public static boolean isTruthy(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return !((String)value).isEmpty() && !"0".equals(value) && !"false".equalsIgnoreCase((String)value);
        }
        if (value instanceof Collection) {
            return !((Collection)value).isEmpty();
        }
        if (value instanceof Number) {
            return ((Number)value).doubleValue() != 0.0;
        }
        return true;
    }

    public String getCondition() {
        return this.condition;
    }

    public String getTrueExpr() {
        return this.trueExpr;
    }

    public String getFalseExpr() {
        return this.falseExpr;
    }
}

