/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.image.volcengine;

import com.agentsflex.core.image.EditImageRequest;
import com.agentsflex.core.image.GenerateImageRequest;
import com.agentsflex.core.image.ImageModel;
import com.agentsflex.core.image.ImageResponse;
import com.agentsflex.core.image.VaryImageRequest;
import com.agentsflex.image.volcengine.VolcengineImageModelConfig;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.volcengine.service.visual.IVisualService;
import com.volcengine.service.visual.impl.VisualServiceImpl;

public class VolcengineImageModel
implements ImageModel {
    private VolcengineImageModelConfig config;
    private IVisualService visualService = VisualServiceImpl.getInstance();

    public VolcengineImageModel(VolcengineImageModelConfig config) {
        this.config = config;
        this.visualService.setAccessKey(config.getAccessKey());
        this.visualService.setSecretKey(config.getSecretKey());
    }

    private ImageResponse processImageRequest(GenerateImageRequest request) {
        JSONObject req = new JSONObject(request.getOptions());
        ImageResponse responseimage = new ImageResponse();
        try {
            Object response = this.visualService.cvProcess((Object)req);
            if (response instanceof JSONObject) {
                JSONObject jsonResponse = (JSONObject)response;
                JSONObject dataObject = jsonResponse.getJSONObject("data");
                JSONArray imageUrlsArray = dataObject.getJSONArray("image_urls");
                for (int i = 0; i < imageUrlsArray.size(); ++i) {
                    responseimage.addImage(imageUrlsArray.getString(i));
                }
            } else {
                throw new RuntimeException("Unexpected response type: " + response.getClass().getName());
            }
            return responseimage;
        }
        catch (Exception e) {
            ImageResponse.error((String)e.getMessage());
            e.printStackTrace();
            return responseimage;
        }
    }

    public ImageResponse generate(GenerateImageRequest request) {
        return this.processImageRequest(request);
    }

    public ImageResponse img2imggenerate(GenerateImageRequest request) {
        return this.processImageRequest(request);
    }

    public ImageResponse edit(EditImageRequest request) {
        throw new UnsupportedOperationException("not support edit image");
    }

    public ImageResponse vary(VaryImageRequest request) {
        throw new UnsupportedOperationException("not support vary image");
    }
}

