/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.deepseek;

import com.agentsflex.core.document.Document;
import com.agentsflex.core.llm.BaseLlm;
import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.llm.Llm;
import com.agentsflex.core.llm.LlmConfig;
import com.agentsflex.core.llm.StreamResponseListener;
import com.agentsflex.core.llm.client.BaseLlmClientListener;
import com.agentsflex.core.llm.client.HttpClient;
import com.agentsflex.core.llm.client.LlmClient;
import com.agentsflex.core.llm.client.LlmClientListener;
import com.agentsflex.core.llm.client.impl.SseClient;
import com.agentsflex.core.llm.embedding.EmbeddingOptions;
import com.agentsflex.core.llm.response.AiMessageResponse;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.store.VectorData;
import com.agentsflex.core.util.LogUtil;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.llm.deepseek.DeepseekConfig;
import com.agentsflex.llm.deepseek.DeepseekLlmUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class DeepseekLlm
extends BaseLlm<DeepseekConfig> {
    private final Map<String, String> headers = new HashMap<String, String>();
    private final HttpClient httpClient = new HttpClient();
    private final AiMessageParser aiMessageParser = DeepseekLlmUtil.getAiMessageParser(false);
    private final AiMessageParser streamMessageParser = DeepseekLlmUtil.getAiMessageParser(true);

    public DeepseekLlm(DeepseekConfig config) {
        super((LlmConfig)config);
        this.headers.put("Content-Type", "application/json");
        this.headers.put("Accept", "application/json");
        this.headers.put("Authorization", "Bearer " + ((DeepseekConfig)this.getConfig()).getApiKey());
    }

    public static DeepseekLlm of(String apiKey) {
        DeepseekConfig config = new DeepseekConfig();
        config.setApiKey(apiKey);
        return new DeepseekLlm(config);
    }

    public AiMessageResponse chat(Prompt prompt, ChatOptions options) {
        Consumer headersConfig = ((DeepseekConfig)this.config).getHeadersConfig();
        if (headersConfig != null) {
            headersConfig.accept(this.headers);
        }
        String payload = DeepseekLlmUtil.promptToPayload(prompt, this.config, options, false);
        String endpoint = ((DeepseekConfig)this.config).getEndpoint();
        String response = this.httpClient.post(endpoint + "/chat/completions", this.headers, payload);
        if (((DeepseekConfig)this.config).isDebug()) {
            LogUtil.println((String)(">>>>receive payload:" + response));
        }
        if (StringUtil.noText((String)response)) {
            return AiMessageResponse.error((Prompt)prompt, (String)response, (String)"no content for response.");
        }
        JSONObject jsonObject = JSON.parseObject((String)response);
        JSONObject error = jsonObject.getJSONObject("error");
        AiMessageResponse messageResponse = new AiMessageResponse(prompt, response, (AiMessage)this.aiMessageParser.parse((Object)jsonObject));
        if (error != null && !error.isEmpty()) {
            messageResponse.setError(true);
            messageResponse.setErrorMessage(error.getString("message"));
            messageResponse.setErrorType(error.getString("type"));
            messageResponse.setErrorCode(error.getString("code"));
        }
        return messageResponse;
    }

    public void chatStream(Prompt prompt, StreamResponseListener streamResponseListener, ChatOptions chatOptions) {
        SseClient llmClient = new SseClient();
        String payload = DeepseekLlmUtil.promptToPayload(prompt, this.config, chatOptions, true);
        String endpoint = ((DeepseekConfig)this.config).getEndpoint();
        BaseLlmClientListener clientListener = new BaseLlmClientListener((Llm)this, (LlmClient)llmClient, streamResponseListener, prompt, this.streamMessageParser);
        llmClient.start(endpoint + "/chat/completions", this.headers, payload, (LlmClientListener)clientListener, this.config);
    }

    public void chatStream(Prompt prompt, StreamResponseListener streamResponseListener) {
        this.chatStream(prompt, streamResponseListener, ChatOptions.DEFAULT);
    }

    public VectorData embed(Document document, EmbeddingOptions embeddingOptions) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

