/*
 * Decompiled with CFR 0.152.
 */
package com.agentsflex.llm.tencent;

import com.agentsflex.core.llm.ChatOptions;
import com.agentsflex.core.message.AiMessage;
import com.agentsflex.core.message.HumanImageMessage;
import com.agentsflex.core.message.HumanMessage;
import com.agentsflex.core.message.Message;
import com.agentsflex.core.message.MessageStatus;
import com.agentsflex.core.message.SystemMessage;
import com.agentsflex.core.message.ToolMessage;
import com.agentsflex.core.parser.AiMessageParser;
import com.agentsflex.core.parser.impl.DefaultAiMessageParser;
import com.agentsflex.core.prompt.DefaultPromptFormat;
import com.agentsflex.core.prompt.ImagePrompt;
import com.agentsflex.core.prompt.Prompt;
import com.agentsflex.core.prompt.PromptFormat;
import com.agentsflex.core.util.Maps;
import com.agentsflex.core.util.MessageUtil;
import com.agentsflex.core.util.StringUtil;
import com.agentsflex.llm.tencent.TencentLlmConfig;
import com.alibaba.fastjson.JSONPath;
import com.tencentcloudapi.common.DatatypeConverter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class TencentLlmUtil {
    private static final PromptFormat promptFormat = new DefaultPromptFormat(){

        protected void buildMessageContent(Message message, Map<String, Object> map) {
            map.clear();
            if (message instanceof HumanMessage) {
                map.put("Role", "user");
            } else if (message instanceof AiMessage) {
                map.put("Role", "assistant");
                map.put("Content", "");
                AiMessage aiMessage = (AiMessage)message;
                List calls = aiMessage.getCalls();
                if (calls != null && !calls.isEmpty()) {
                    this.buildToolCalls(map, calls);
                    return;
                }
            } else if (message instanceof SystemMessage) {
                map.put("Role", "system");
            } else if (message instanceof ToolMessage) {
                map.put("Role", "tool");
                map.put("Tool_call_id", ((ToolMessage)message).getToolCallId());
            }
            if (message instanceof HumanImageMessage) {
                ImagePrompt prompt = ((HumanImageMessage)message).getPrompt();
                ArrayList<Maps> list = new ArrayList<Maps>();
                List imageUrls = prompt.getImageUrls();
                if (imageUrls != null) {
                    for (String imageUrl : imageUrls) {
                        list.add(Maps.of((String)"Type", (Object)"image_url").set("Text", (Object)prompt.getContent()).set("ImageUrl", (Object)Maps.of((String)"Url", (Object)imageUrl)));
                    }
                }
                map.put("Contents", list);
            } else {
                map.put("Content", message.getMessageContent());
            }
        }

        protected Object buildToolCallsArguments(Map<String, Object> arguments) {
            return arguments;
        }
    };
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final String CT_JSON = "application/json; charset=utf-8";

    public static byte[] hmac256(byte[] key, String msg) throws Exception {
        Mac mac = Mac.getInstance("HmacSHA256");
        SecretKeySpec secretKeySpec = new SecretKeySpec(key, mac.getAlgorithm());
        mac.init(secretKeySpec);
        return mac.doFinal(msg.getBytes(UTF8));
    }

    public static String sha256Hex(String s) throws Exception {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] d = md.digest(s.getBytes(UTF8));
        return DatatypeConverter.printHexBinary((byte[])d).toLowerCase();
    }

    public static Map<String, String> createAuthorizationToken(TencentLlmConfig config, String action, String payload) {
        try {
            String service = config.getService();
            String host = config.getHost();
            String version = "2023-09-01";
            String algorithm = "TC3-HMAC-SHA256";
            String timestamp = String.valueOf(System.currentTimeMillis() / 1000L);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
            String date = sdf.format(new Date(Long.parseLong(timestamp + "000")));
            String httpRequestMethod = "POST";
            String canonicalUri = "/";
            String canonicalQueryString = "";
            String canonicalHeaders = "content-type:application/json; charset=utf-8\nhost:" + host + "\nx-tc-action:" + action.toLowerCase() + "\n";
            String signedHeaders = "content-type;host;x-tc-action";
            String hashedRequestPayload = TencentLlmUtil.sha256Hex(payload);
            String canonicalRequest = httpRequestMethod + "\n" + canonicalUri + "\n" + canonicalQueryString + "\n" + canonicalHeaders + "\n" + signedHeaders + "\n" + hashedRequestPayload;
            System.out.println(canonicalRequest);
            String credentialScope = date + "/" + service + "/tc3_request";
            String hashedCanonicalRequest = TencentLlmUtil.sha256Hex(canonicalRequest);
            String stringToSign = algorithm + "\n" + timestamp + "\n" + credentialScope + "\n" + hashedCanonicalRequest;
            System.out.println(stringToSign);
            byte[] secretDate = TencentLlmUtil.hmac256(("TC3" + config.getApiKey()).getBytes(UTF8), date);
            byte[] secretService = TencentLlmUtil.hmac256(secretDate, service);
            byte[] secretSigning = TencentLlmUtil.hmac256(secretService, "tc3_request");
            String signature = DatatypeConverter.printHexBinary((byte[])TencentLlmUtil.hmac256(secretSigning, stringToSign)).toLowerCase();
            System.out.println(signature);
            String authorization = algorithm + " Credential=" + config.getApiSecret() + "/" + credentialScope + ", SignedHeaders=" + signedHeaders + ", Signature=" + signature;
            System.out.println(authorization);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Authorization", authorization);
            headers.put("Content-Type", CT_JSON);
            headers.put("Host", host);
            headers.put("X-TC-Action", action);
            headers.put("X-TC-Timestamp", timestamp);
            headers.put("X-TC-Version", version);
            return headers;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static AiMessageParser getAiMessageParser(boolean isStream) {
        DefaultAiMessageParser aiMessageParser = new DefaultAiMessageParser();
        String data = isStream ? "" : "Response.";
        aiMessageParser.setIndexPath("$." + data + "choices[0].Index");
        if (isStream) {
            aiMessageParser.setContentPath("$." + data + "Choices[0].Delta.Content");
        } else {
            aiMessageParser.setContentPath("$." + data + "Choices[0].Message.Content");
        }
        aiMessageParser.setTotalTokensPath("$." + data + "Usage.TotalTokens");
        aiMessageParser.setCompletionTokensPath("$." + data + "Usage.CompletionTokens");
        aiMessageParser.setPromptTokensPath("$." + data + "Usage.PromptTokens");
        aiMessageParser.setStatusParser(content -> {
            String done = (String)JSONPath.eval((Object)content, (String)("$." + data + "Choices[0].FinishReason"));
            if (StringUtil.hasText((String)done)) {
                return MessageStatus.END;
            }
            return MessageStatus.MIDDLE;
        });
        return aiMessageParser;
    }

    public static String promptToPayload(Prompt prompt, TencentLlmConfig config, boolean withStream, ChatOptions options) {
        List messages = prompt.toMessages();
        HumanMessage message = MessageUtil.findLastHumanMessage((List)messages);
        return Maps.of((String)"Model", (Object)Optional.ofNullable(options.getModel()).orElse(config.getModel())).set("Messages", promptFormat.toMessagesJsonObject(messages)).setIf(withStream, "Stream", (Object)withStream).setIfNotEmpty("Tools", promptFormat.toFunctionsJsonObject(message)).setIfContainsKey("Tools", "ToolChoice", (Object)MessageUtil.getToolChoice((Message)message)).setIfNotNull("top_p", (Object)options.getTopP()).setIfNotEmpty("Stop", (Object)options.getStop()).setIf(map -> !map.containsKey((Object)"tools") && options.getMaxTokens() != null, "max_tokens", (Object)options.getMaxTokens()).setIfNotEmpty(options.getExtra()).toJSON();
    }
}

