/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.callback.future;

import com.aizuda.snailjob.client.common.rpc.client.RequestBuilder;
import com.aizuda.snailjob.client.core.client.RetryClient;
import com.aizuda.snailjob.client.core.context.CallbackContext;
import com.aizuda.snailjob.client.model.request.DispatchCallbackResultRequest;
import com.aizuda.snailjob.common.core.enums.RetryTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.google.common.util.concurrent.FutureCallback;
import java.util.concurrent.CancellationException;

public class CallbackTaskExecutorFutureCallback
implements FutureCallback<Boolean> {
    private static final RetryClient CLIENT = (RetryClient)RequestBuilder.newBuilder().client(RetryClient.class).callback(nettyResult -> {
        if (nettyResult.getStatus() == StatusEnum.NO.getStatus().intValue()) {
            SnailJobLog.LOCAL.error("Retry callback execute result report successfully requestId:[{}]", new Object[]{nettyResult.getReqId()});
        }
    }).build();
    private final CallbackContext context;

    public CallbackTaskExecutorFutureCallback(CallbackContext context) {
        this.context = context;
    }

    public void onSuccess(Boolean result) {
        try {
            DispatchCallbackResultRequest request = this.buildDispatchRetryResultRequest();
            request.setTaskStatus(RetryTaskStatusEnum.SUCCESS.getStatus());
            CLIENT.callbackResult(request);
        }
        catch (Exception e) {
            SnailJobLog.REMOTE.error("Callback execution result reporting exception.[{}]", new Object[]{this.context.getRetryTaskId(), e});
        }
    }

    public void onFailure(Throwable t) {
        if (t instanceof CancellationException) {
            SnailJobLog.LOCAL.debug("The task has been canceled, no status feedback will be made", new Object[0]);
            return;
        }
        try {
            DispatchCallbackResultRequest request = this.buildDispatchRetryResultRequest();
            request.setTaskStatus(RetryTaskStatusEnum.FAIL.getStatus());
            request.setExceptionMsg(t.getMessage());
            CLIENT.callbackResult(request);
        }
        catch (Exception e) {
            SnailJobLog.REMOTE.error("Callback execution result reporting exception.[{}]", new Object[]{this.context.getRetryTaskId(), e});
        }
    }

    private DispatchCallbackResultRequest buildDispatchRetryResultRequest() {
        DispatchCallbackResultRequest request = new DispatchCallbackResultRequest();
        request.setRetryTaskId(this.context.getRetryTaskId());
        request.setNamespaceId(this.context.getNamespaceId());
        request.setGroupName(this.context.getGroupName());
        request.setSceneName(this.context.getSceneName());
        request.setRetryId(this.context.getRetryId());
        request.setRetryTaskId(this.context.getRetryTaskId());
        return request;
    }
}

