/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.client.core.register;

import com.aizuda.snailjob.client.common.Lifecycle;
import com.aizuda.snailjob.client.core.Scanner;
import com.aizuda.snailjob.client.core.cache.RetryerInfoCache;
import com.aizuda.snailjob.client.core.exception.SnailRetryClientException;
import com.aizuda.snailjob.client.core.retryer.RetryerInfo;
import java.util.List;
import java.util.Objects;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RetryableRegistrar
implements Lifecycle {
    @Autowired
    private List<Scanner> scanners;

    public void registerRetryHandler(RetryerInfo retryerInfo) {
        if (Objects.nonNull(RetryerInfoCache.get(retryerInfo.getScene(), retryerInfo.getExecutorClassName()))) {
            throw new SnailRetryClientException("Scene [{}] already exists in class [{}]", retryerInfo.getExecutorClassName(), retryerInfo.getScene());
        }
        RetryerInfoCache.put(retryerInfo);
    }

    public void registerRetryHandler(List<RetryerInfo> contextList) {
        for (RetryerInfo retryerInfo : contextList) {
            this.registerRetryHandler(retryerInfo);
        }
    }

    public void start() {
        for (Scanner scanner : this.scanners) {
            this.registerRetryHandler(scanner.doScan());
        }
    }

    public void close() {
    }
}

