/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.common.core.enums;

import com.aizuda.snailjob.common.core.enums.NodeTypeEnum;
import lombok.Generated;

public enum RetryNotifySceneEnum {
    NONE(0, "", NodeTypeEnum.SERVER),
    MAX_RETRY(1, "Scene retry count exceeds threshold", NodeTypeEnum.SERVER),
    MAX_RETRY_ERROR(2, "Scene retry failure count exceeds threshold", NodeTypeEnum.SERVER),
    CLIENT_REPORT_ERROR(3, "Client report failed", NodeTypeEnum.CLIENT),
    CLIENT_COMPONENT_ERROR(4, "Client component exception", NodeTypeEnum.CLIENT),
    RETRY_TASK_FAIL_ERROR(5, "Task retry failed", NodeTypeEnum.SERVER),
    RETRY_TASK_ENTER_DEAD_LETTER(6, "Task retry failed and entered dead letter queue", NodeTypeEnum.SERVER),
    RETRY_NO_CLIENT_NODES_ERROR(7, "Task retry failed (no executable client nodes)", NodeTypeEnum.SERVER);

    private final int notifyScene;
    private final String desc;
    private final NodeTypeEnum nodeType;

    public static RetryNotifySceneEnum getNotifyScene(int notifyScene, NodeTypeEnum nodeType) {
        for (RetryNotifySceneEnum sceneEnum : RetryNotifySceneEnum.values()) {
            if (sceneEnum.getNotifyScene() != notifyScene || !sceneEnum.nodeType.getType().equals(nodeType.getType())) continue;
            return sceneEnum;
        }
        return null;
    }

    public static RetryNotifySceneEnum getRetryNotifyScene(Integer notifyScene) {
        for (RetryNotifySceneEnum sceneEnum : RetryNotifySceneEnum.values()) {
            if (sceneEnum.getNotifyScene() != notifyScene.intValue()) continue;
            return sceneEnum;
        }
        return NONE;
    }

    @Generated
    private RetryNotifySceneEnum(int notifyScene, String desc, NodeTypeEnum nodeType) {
        this.notifyScene = notifyScene;
        this.desc = desc;
        this.nodeType = nodeType;
    }

    @Generated
    public int getNotifyScene() {
        return this.notifyScene;
    }

    @Generated
    public String getDesc() {
        return this.desc;
    }

    @Generated
    public NodeTypeEnum getNodeType() {
        return this.nodeType;
    }
}

