/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.common.register;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.IdUtil;
import com.aizuda.snailjob.common.core.enums.NodeTypeEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.NetUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.cache.CacheConsumerGroup;
import com.aizuda.snailjob.server.common.cache.CacheRegisterTable;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.dto.ServerNodeExtAttrs;
import com.aizuda.snailjob.server.common.register.AbstractRegister;
import com.aizuda.snailjob.server.common.register.RegisterContext;
import com.aizuda.snailjob.template.datasource.persistence.po.ServerNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.stereotype.Component;

@Component(value="serverRegister")
public class ServerRegister
extends AbstractRegister {
    public static final String BEAN_NAME = "serverRegister";
    private final ScheduledExecutorService serverRegisterNode = Executors.newSingleThreadScheduledExecutor(r -> new Thread(r, "server-register-node"));
    public static final int DELAY_TIME = 30;
    public static final String CURRENT_CID = IdUtil.getSnowflakeNextIdStr();
    public static final String GROUP_NAME = "DEFAULT_SERVER";
    public static final String NAMESPACE_ID = "DEFAULT_SERVER_NAMESPACE_ID";
    private final SystemProperties systemProperties;
    private final ServerProperties serverProperties;

    @Override
    public boolean supports(int type) {
        return this.getNodeType().equals(type);
    }

    @Override
    protected void beforeProcessor(RegisterContext context) {
        ServerNodeExtAttrs serverNodeExtAttrs = new ServerNodeExtAttrs();
        serverNodeExtAttrs.setWebPort(this.serverProperties.getPort());
        context.setGroupName(GROUP_NAME);
        context.setHostId(CURRENT_CID);
        context.setHostIp(NetUtil.getLocalIpStr());
        context.setHostPort(this.systemProperties.getServerPort());
        context.setContextPath(Optional.ofNullable(this.serverProperties.getServlet().getContextPath()).orElse(""));
        context.setNamespaceId(NAMESPACE_ID);
        context.setExtAttrs(JsonUtil.toJsonString((Object)serverNodeExtAttrs));
    }

    @Override
    protected LocalDateTime getExpireAt() {
        return LocalDateTime.now().plusSeconds(30L);
    }

    @Override
    protected boolean doRegister(RegisterContext context, ServerNode serverNode) {
        this.refreshExpireAt(Lists.newArrayList((Object[])new ServerNode[]{serverNode}));
        return Boolean.TRUE;
    }

    @Override
    protected void afterProcessor(ServerNode serverNode) {
        try {
            ConcurrentMap<String, Set<String>> allConsumerGroupName = CacheConsumerGroup.getAllConsumerGroupName();
            if (CollUtil.isNotEmpty(allConsumerGroupName)) {
                Set namespaceIdSets = StreamUtils.toSetByFlatMap(allConsumerGroupName.values(), Collection::stream);
                if (CollUtil.isEmpty((Collection)namespaceIdSets)) {
                    return;
                }
                List serverNodes = this.serverNodeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(ServerNode::getNodeType, (Object)NodeTypeEnum.CLIENT.getType())).in(ServerNode::getNamespaceId, (Collection)namespaceIdSets)).in(ServerNode::getGroupName, allConsumerGroupName.keySet()));
                for (ServerNode node : serverNodes) {
                    CacheRegisterTable.addOrUpdate(node);
                    CacheConsumerGroup.addOrUpdate(node.getGroupName(), node.getNamespaceId());
                }
            }
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("Client refresh failed", new Object[]{e});
        }
    }

    @Override
    protected Integer getNodeType() {
        return NodeTypeEnum.SERVER.getType();
    }

    @Override
    public void start() {
        SnailJobLog.LOCAL.info("ServerRegister start", new Object[0]);
        this.serverRegisterNode.scheduleAtFixedRate(() -> {
            try {
                this.register(new RegisterContext());
            }
            catch (Exception e) {
                SnailJobLog.LOCAL.error("Server-side registration failed", new Object[]{e});
            }
        }, 0L, 20L, TimeUnit.SECONDS);
    }

    @Override
    public void close() {
        SnailJobLog.LOCAL.info("ServerRegister close", new Object[0]);
    }

    @Generated
    public ServerRegister(SystemProperties systemProperties, ServerProperties serverProperties) {
        this.systemProperties = systemProperties;
        this.serverProperties = serverProperties;
    }
}

