/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.job.task.support.generator.task;

import cn.hutool.core.lang.Assert;
import com.aizuda.snailjob.common.core.enums.JobArgsTypeEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskStatusEnum;
import com.aizuda.snailjob.common.core.enums.JobTaskTypeEnum;
import com.aizuda.snailjob.common.core.model.JobArgsHolder;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.dto.RegisterNodeInfo;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.ClientNodeAllocateHandler;
import com.aizuda.snailjob.server.common.util.ClientInfoUtils;
import com.aizuda.snailjob.server.job.task.support.JobTaskConverter;
import com.aizuda.snailjob.server.job.task.support.generator.task.AbstractJobTaskGenerator;
import com.aizuda.snailjob.server.job.task.support.generator.task.JobTaskGenerateContext;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobTaskMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.JobTask;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.springframework.stereotype.Component;

@Component
public class ClusterTaskGenerator
extends AbstractJobTaskGenerator {
    private static final String TASK_NAME = "CLUSTER_TASK";
    private final ClientNodeAllocateHandler clientNodeAllocateHandler;
    private final JobTaskMapper jobTaskMapper;

    @Override
    public JobTaskTypeEnum getTaskInstanceType() {
        return JobTaskTypeEnum.CLUSTER;
    }

    @Override
    public List<JobTask> doGenerate(JobTaskGenerateContext context) {
        RegisterNodeInfo serverNode = this.clientNodeAllocateHandler.getServerNode(context.getJobId().toString(), context.getGroupName(), context.getNamespaceId(), context.getRouteKey());
        if (Objects.isNull(serverNode)) {
            SnailJobLog.LOCAL.error("No executable client information. Job ID:[{}]", new Object[]{context.getJobId()});
            return Lists.newArrayList();
        }
        JobTask jobTask = JobTaskConverter.INSTANCE.toJobTaskInstance(context);
        jobTask.setClientInfo(ClientInfoUtils.generate((RegisterNodeInfo)serverNode));
        jobTask.setArgsType(JobArgsTypeEnum.JSON.getArgsType());
        JobArgsHolder jobArgsHolder = new JobArgsHolder();
        jobArgsHolder.setJobParams((Object)context.getArgsStr());
        jobTask.setArgsStr(JsonUtil.toJsonString((Object)jobArgsHolder));
        jobTask.setTaskStatus(Integer.valueOf(JobTaskStatusEnum.RUNNING.getStatus()));
        jobTask.setTaskName(TASK_NAME);
        jobTask.setResultMessage(Optional.ofNullable(jobTask.getResultMessage()).orElse(""));
        Assert.isTrue((1 == this.jobTaskMapper.insert((Object)jobTask) ? 1 : 0) != 0, () -> new SnailJobServerException("Adding new task instance failed"));
        return Lists.newArrayList((Object[])new JobTask[]{jobTask});
    }

    @Generated
    public ClusterTaskGenerator(ClientNodeAllocateHandler clientNodeAllocateHandler, JobTaskMapper jobTaskMapper) {
        this.clientNodeAllocateHandler = clientNodeAllocateHandler;
        this.jobTaskMapper = jobTaskMapper;
    }
}

