/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import com.aizuda.snailjob.server.common.vo.JobBatchResponseVO;
import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.JobBatchQueryVO;
import com.aizuda.snailjob.server.web.service.JobBatchService;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Size;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/job/batch"})
public class JobBatchController {
    private final JobBatchService jobBatchService;

    @GetMapping(value={"/list"})
    @LoginRequired
    public PageResult<List<JobBatchResponseVO>> getJobBatchPage(JobBatchQueryVO jobQueryVO) {
        return this.jobBatchService.getJobBatchPage(jobQueryVO);
    }

    @GetMapping(value={"{id}"})
    @LoginRequired
    public JobBatchResponseVO getJobBatchDetail(@PathVariable(value="id") Long id) {
        return this.jobBatchService.getJobBatchDetail(id);
    }

    @PostMapping(value={"/stop/{taskBatchId}"})
    @LoginRequired
    public Boolean stop(@PathVariable(value="taskBatchId") Long taskBatchId) {
        return this.jobBatchService.stop(taskBatchId);
    }

    @PostMapping(value={"/retry/{taskBatchId}"})
    @LoginRequired
    public Boolean retry(@PathVariable(value="taskBatchId") Long taskBatchId) {
        return this.jobBatchService.retry(taskBatchId);
    }

    @DeleteMapping(value={"/ids"})
    @LoginRequired
    public Boolean deleteJobBatchByIds(@RequestBody @NotEmpty(message="ids cannot be null") @Size(max=100, message="Maximum {max} deletions") @NotEmpty(message="ids cannot be null") @Size(max=100, message="Maximum {max} deletions") Set<Long> ids) {
        return this.jobBatchService.deleteJobBatchByIds(ids);
    }

    @Generated
    public JobBatchController(JobBatchService jobBatchService) {
        this.jobBatchService = jobBatchService;
    }
}

