/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.controller;

import cn.hutool.core.lang.Pair;
import com.aizuda.snailjob.common.core.annotation.OriginalControllerReturnValue;
import com.aizuda.snailjob.server.common.vo.WorkflowDetailResponseVO;
import com.aizuda.snailjob.server.common.vo.WorkflowResponseVO;
import com.aizuda.snailjob.server.common.vo.request.WorkflowRequestVO;
import com.aizuda.snailjob.server.web.annotation.LoginRequired;
import com.aizuda.snailjob.server.web.annotation.RoleEnum;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.CheckDecisionVO;
import com.aizuda.snailjob.server.web.model.request.ExportWorkflowVO;
import com.aizuda.snailjob.server.web.model.request.WorkflowQueryVO;
import com.aizuda.snailjob.server.web.model.request.WorkflowTriggerVO;
import com.aizuda.snailjob.server.web.service.WorkflowService;
import com.aizuda.snailjob.server.web.util.ExportUtils;
import com.aizuda.snailjob.server.web.util.ImportUtils;
import jakarta.validation.constraints.NotEmpty;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/workflow"})
public class WorkflowController {
    private final WorkflowService workflowService;

    @PostMapping
    @LoginRequired(role=RoleEnum.USER)
    public Boolean saveWorkflow(@RequestBody @Validated WorkflowRequestVO workflowRequestVO) {
        return this.workflowService.saveWorkflow(workflowRequestVO);
    }

    @GetMapping(value={"/page/list"})
    @LoginRequired(role=RoleEnum.USER)
    public PageResult<List<WorkflowResponseVO>> listPage(WorkflowQueryVO queryVO) {
        return this.workflowService.listPage(queryVO);
    }

    @PutMapping
    @LoginRequired(role=RoleEnum.USER)
    public Boolean updateWorkflow(@RequestBody @Validated WorkflowRequestVO workflowRequestVO) {
        return this.workflowService.updateWorkflow(workflowRequestVO);
    }

    @GetMapping(value={"{id}"})
    @LoginRequired(role=RoleEnum.USER)
    public WorkflowDetailResponseVO getWorkflowDetail(@PathVariable(value="id") Long id) throws IOException {
        return this.workflowService.getWorkflowDetail(id);
    }

    @PutMapping(value={"/update/status/{id}"})
    @LoginRequired(role=RoleEnum.USER)
    public Boolean updateStatus(@PathVariable(value="id") Long id) {
        return this.workflowService.updateStatus(id);
    }

    @DeleteMapping(value={"/ids"})
    @LoginRequired(role=RoleEnum.USER)
    public Boolean deleteByIds(@RequestBody @NotEmpty(message="ids cannot be null") @NotEmpty(message="ids cannot be null") Set<Long> ids) {
        return this.workflowService.deleteByIds(ids);
    }

    @PostMapping(value={"/trigger"})
    @LoginRequired(role=RoleEnum.USER)
    public Boolean trigger(@RequestBody @Validated WorkflowTriggerVO triggerVO) {
        return this.workflowService.trigger(triggerVO);
    }

    @GetMapping(value={"/workflow-name/list"})
    @LoginRequired(role=RoleEnum.USER)
    public List<WorkflowResponseVO> getWorkflowNameList(@RequestParam(value="keywords", required=false) String keywords, @RequestParam(value="workflowId", required=false) Long workflowId, @RequestParam(value="groupName", required=false) String groupName) {
        return this.workflowService.getWorkflowNameList(keywords, workflowId, groupName);
    }

    @PostMapping(value={"/check-node-expression"})
    @LoginRequired(role=RoleEnum.USER)
    public Pair<Integer, Object> checkNodeExpression(@RequestBody @Validated CheckDecisionVO checkDecisionVO) {
        return this.workflowService.checkNodeExpression(checkDecisionVO);
    }

    @LoginRequired
    @PostMapping(value={"/import"}, consumes={"multipart/form-data"})
    public void importScene(@RequestPart(value="file") MultipartFile file) throws IOException {
        this.workflowService.importWorkflowTask(ImportUtils.parseList(file, WorkflowRequestVO.class));
    }

    @LoginRequired
    @PostMapping(value={"/export"})
    @OriginalControllerReturnValue
    public ResponseEntity<String> export(@RequestBody ExportWorkflowVO exportWorkflowVO) {
        return ExportUtils.doExport(this.workflowService.exportWorkflowTask(exportWorkflowVO));
    }

    @Generated
    public WorkflowController(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }
}

