/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.server.common.dto.PartitionTask;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.CronUtils;
import com.aizuda.snailjob.server.common.util.PartitionTaskUtils;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.ExportSceneVO;
import com.aizuda.snailjob.server.web.model.request.SceneConfigQueryVO;
import com.aizuda.snailjob.server.web.model.request.SceneConfigRequestVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.response.SceneConfigResponseVO;
import com.aizuda.snailjob.server.web.service.SceneConfigService;
import com.aizuda.snailjob.server.web.service.convert.SceneConfigConverter;
import com.aizuda.snailjob.server.web.service.convert.SceneConfigResponseVOConverter;
import com.aizuda.snailjob.server.web.service.handler.GroupHandler;
import com.aizuda.snailjob.server.web.service.handler.SyncConfigHandler;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.access.ConfigAccess;
import com.aizuda.snailjob.template.datasource.access.TaskAccess;
import com.aizuda.snailjob.template.datasource.persistence.mapper.RetrySummaryMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.CreateDt;
import com.aizuda.snailjob.template.datasource.persistence.po.Retry;
import com.aizuda.snailjob.template.datasource.persistence.po.RetryDeadLetter;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySceneConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.RetrySummary;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Service
@Validated
public class SceneConfigServiceImpl
implements SceneConfigService {
    private final AccessTemplate accessTemplate;
    private final GroupHandler groupHandler;
    private final RetrySummaryMapper retrySummaryMapper;

    @Override
    public PageResult<List<SceneConfigResponseVO>> getSceneConfigPageList(SceneConfigQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        List<String> groupNames = UserSessionUtils.getGroupNames(queryVO.getGroupName());
        pageDTO = this.accessTemplate.getSceneConfigAccess().listPage(pageDTO, (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySceneConfig::getNamespaceId, (Object)userSessionVO.getNamespaceId())).in(CollUtil.isNotEmpty(groupNames), RetrySceneConfig::getGroupName, groupNames)).eq(Objects.nonNull(queryVO.getSceneStatus()), RetrySceneConfig::getSceneStatus, (Object)queryVO.getSceneStatus())).likeRight(StrUtil.isNotBlank((CharSequence)queryVO.getSceneName()), RetrySceneConfig::getSceneName, (Object)StrUtil.trim((CharSequence)queryVO.getSceneName()))).orderByDesc(CreateDt::getCreateDt));
        return new PageResult<List<SceneConfigResponseVO>>(pageDTO, SceneConfigResponseVOConverter.INSTANCE.convertList(pageDTO.getRecords()));
    }

    @Override
    public List<SceneConfigResponseVO> getSceneConfigList(String groupName) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        List retrySceneConfigs = this.accessTemplate.getSceneConfigAccess().list((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySceneConfig::getNamespaceId, (Object)namespaceId)).eq(RetrySceneConfig::getGroupName, (Object)groupName)).select(new SFunction[]{RetrySceneConfig::getSceneName, RetrySceneConfig::getDescription, RetrySceneConfig::getMaxRetryCount}).orderByDesc(CreateDt::getCreateDt));
        return SceneConfigResponseVOConverter.INSTANCE.convertList(retrySceneConfigs);
    }

    @Override
    public Boolean saveSceneConfig(SceneConfigRequestVO requestVO) {
        SceneConfigServiceImpl.checkExecuteInterval(requestVO.getBackOff(), requestVO.getTriggerInterval());
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        ConfigAccess sceneConfigAccess = this.accessTemplate.getSceneConfigAccess();
        Assert.isTrue((0L == sceneConfigAccess.count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySceneConfig::getNamespaceId, (Object)namespaceId)).eq(RetrySceneConfig::getGroupName, (Object)requestVO.getGroupName())).eq(RetrySceneConfig::getSceneName, (Object)requestVO.getSceneName())) ? 1 : 0) != 0, () -> new SnailJobServerException("Scene name duplicate. {}", new Object[]{requestVO.getSceneName()}));
        RetrySceneConfig retrySceneConfig = SceneConfigConverter.INSTANCE.toRetrySceneConfig(requestVO);
        retrySceneConfig.setCreateDt(LocalDateTime.now());
        retrySceneConfig.setNamespaceId(namespaceId);
        if (requestVO.getBackOff().intValue() == WaitStrategies.WaitStrategyEnum.DELAY_LEVEL.getType()) {
            retrySceneConfig.setTriggerInterval("");
        }
        if (Objects.equals(requestVO.getCbStatus(), StatusEnum.YES.getStatus())) {
            SceneConfigServiceImpl.checkExecuteInterval(requestVO.getCbTriggerType(), requestVO.getCbTriggerInterval());
            if (requestVO.getCbTriggerType().intValue() == WaitStrategies.WaitStrategyEnum.DELAY_LEVEL.getType()) {
                retrySceneConfig.setCbTriggerInterval("");
            }
        }
        Assert.isTrue((1 == sceneConfigAccess.insert((Object)retrySceneConfig) ? 1 : 0) != 0, () -> new SnailJobServerException("failed to insert scene. retrySceneConfig:[{}]", new Object[]{JsonUtil.toJsonString((Object)retrySceneConfig)}));
        SyncConfigHandler.addSyncTask(requestVO.getGroupName(), namespaceId);
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateSceneConfig(SceneConfigRequestVO requestVO) {
        SceneConfigServiceImpl.checkExecuteInterval(requestVO.getBackOff(), requestVO.getTriggerInterval());
        RetrySceneConfig retrySceneConfig = SceneConfigConverter.INSTANCE.toRetrySceneConfig(requestVO);
        retrySceneConfig.setSceneName(null);
        retrySceneConfig.setGroupName(null);
        retrySceneConfig.setNamespaceId(null);
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        if (Objects.equals(requestVO.getCbStatus(), StatusEnum.YES.getStatus())) {
            SceneConfigServiceImpl.checkExecuteInterval(requestVO.getCbTriggerType(), requestVO.getCbTriggerInterval());
            if (requestVO.getCbTriggerType().intValue() == WaitStrategies.WaitStrategyEnum.DELAY_LEVEL.getType()) {
                retrySceneConfig.setCbTriggerInterval("");
            }
        }
        retrySceneConfig.setTriggerInterval(Optional.ofNullable(retrySceneConfig.getTriggerInterval()).orElse(""));
        Assert.isTrue((1 == this.accessTemplate.getSceneConfigAccess().update((Object)retrySceneConfig, (LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(RetrySceneConfig::getNamespaceId, (Object)namespaceId)).eq(RetrySceneConfig::getGroupName, (Object)requestVO.getGroupName())).eq(RetrySceneConfig::getSceneName, (Object)requestVO.getSceneName())) ? 1 : 0) != 0, () -> new SnailJobServerException("failed to update scene. retrySceneConfig:[{}]", new Object[]{JsonUtil.toJsonString((Object)retrySceneConfig)}));
        SyncConfigHandler.addSyncTask(requestVO.getGroupName(), namespaceId);
        return Boolean.TRUE;
    }

    @Override
    public SceneConfigResponseVO getSceneConfigDetail(Long id) {
        RetrySceneConfig retrySceneConfig = (RetrySceneConfig)this.accessTemplate.getSceneConfigAccess().one((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySceneConfig::getId, (Object)id));
        return SceneConfigResponseVOConverter.INSTANCE.convert(retrySceneConfig);
    }

    @Override
    public boolean updateStatus(Long id, Integer status) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        RetrySceneConfig config = new RetrySceneConfig();
        config.setSceneStatus(status);
        return 1 == this.accessTemplate.getSceneConfigAccess().update((Object)config, (LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().eq(RetrySceneConfig::getId, (Object)id)).eq(RetrySceneConfig::getNamespaceId, (Object)namespaceId));
    }

    @Override
    @Transactional
    public void importSceneConfig(List<SceneConfigRequestVO> requests) {
        this.batchSaveSceneConfig(requests, UserSessionUtils.currentUserSession().getNamespaceId());
    }

    @Override
    public String exportSceneConfig(ExportSceneVO exportSceneVO) {
        ArrayList requestList = new ArrayList();
        PartitionTaskUtils.process(startId -> {
            List sceneConfigs = this.accessTemplate.getSceneConfigAccess().listPage(new PageDTO(0L, 500L, Boolean.FALSE.booleanValue()), (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetrySceneConfig::getNamespaceId, (Object)UserSessionUtils.currentUserSession().getNamespaceId())).eq(Objects.nonNull(exportSceneVO.getSceneStatus()), RetrySceneConfig::getSceneStatus, (Object)exportSceneVO.getSceneStatus())).eq(StrUtil.isNotBlank((CharSequence)exportSceneVO.getGroupName()), RetrySceneConfig::getGroupName, (Object)StrUtil.trim((CharSequence)exportSceneVO.getGroupName()))).likeRight(StrUtil.isNotBlank((CharSequence)exportSceneVO.getSceneName()), RetrySceneConfig::getSceneName, (Object)StrUtil.trim((CharSequence)exportSceneVO.getSceneName()))).in(CollUtil.isNotEmpty(exportSceneVO.getSceneIds()), RetrySceneConfig::getId, exportSceneVO.getSceneIds())).ge(RetrySceneConfig::getId, (Object)startId)).orderByAsc(RetrySceneConfig::getId)).getRecords();
            return StreamUtils.toList((Collection)sceneConfigs, SceneConfigPartitionTask::new);
        }, partitionTasks -> {
            List partitionTaskList = partitionTasks;
            requestList.addAll(SceneConfigConverter.INSTANCE.toSceneConfigRequestVOs(StreamUtils.toList((Collection)partitionTaskList, SceneConfigPartitionTask::getConfig)));
        }, (long)0L);
        return JsonUtil.toJsonString(requestList);
    }

    @Override
    @Transactional
    public boolean deleteByIds(Set<Long> ids) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{RetrySceneConfig::getSceneName, RetrySceneConfig::getGroupName}).eq(RetrySceneConfig::getNamespaceId, (Object)namespaceId)).eq(RetrySceneConfig::getSceneStatus, (Object)StatusEnum.NO.getStatus())).in(RetrySceneConfig::getId, ids);
        List sceneConfigs = this.accessTemplate.getSceneConfigAccess().list(queryWrapper);
        Assert.notEmpty((Iterable)sceneConfigs, () -> new SnailJobServerException("Failed to delete retry scene, please check if the scene status is closed"));
        Set sceneNames = StreamUtils.toSet((Collection)sceneConfigs, RetrySceneConfig::getSceneName);
        Set groupNames = StreamUtils.toSet((Collection)sceneConfigs, RetrySceneConfig::getGroupName);
        TaskAccess retryTaskAccess = this.accessTemplate.getRetryAccess();
        TaskAccess retryTaskTaskAccess = this.accessTemplate.getRetryDeadLetterAccess();
        for (String groupName : groupNames) {
            List retries = retryTaskAccess.listPage(new PageDTO(1L, 1L), (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Retry::getGroupName, (Object)groupName)).in(Retry::getSceneName, (Collection)sceneNames)).orderByAsc(Retry::getId)).getRecords();
            Assert.isTrue((boolean)CollUtil.isEmpty((Collection)retries), () -> new SnailJobServerException("Failed to delete retry scene, retry tasks exist. Please delete the retry tasks before retrying"));
            List retryDeadLetters = retryTaskTaskAccess.listPage(new PageDTO(1L, 1L), (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RetryDeadLetter::getGroupName, (Object)groupName)).in(RetryDeadLetter::getSceneName, (Collection)sceneNames)).orderByAsc(RetryDeadLetter::getId)).getRecords();
            Assert.isTrue((boolean)CollUtil.isEmpty((Collection)retryDeadLetters), () -> new SnailJobServerException("Failed to delete retry scene, dead letter tasks exist. Please delete the dead letter tasks before retrying"));
        }
        Assert.isTrue((ids.size() == this.accessTemplate.getSceneConfigAccess().delete(queryWrapper) ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to delete retry scene, please check if the scene status is closed"));
        List retrySummaries = this.retrySummaryMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{RetrySummary::getId}).eq(RetrySummary::getNamespaceId, (Object)namespaceId)).in(RetrySummary::getGroupName, (Collection)groupNames)).in(RetrySummary::getSceneName, (Collection)sceneNames));
        if (CollUtil.isNotEmpty((Collection)retrySummaries)) {
            Assert.isTrue((retrySummaries.size() == this.retrySummaryMapper.deleteByIds((Collection)StreamUtils.toSet((Collection)retrySummaries, RetrySummary::getId)) ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to delete summary table data"));
        }
        return Boolean.TRUE;
    }

    private void batchSaveSceneConfig(List<SceneConfigRequestVO> requests, String namespaceId) {
        HashSet groupNameSet = Sets.newHashSet();
        HashSet sceneNameSet = Sets.newHashSet();
        for (SceneConfigRequestVO requestVO : requests) {
            SceneConfigServiceImpl.checkExecuteInterval(requestVO.getBackOff(), requestVO.getTriggerInterval());
            if (Objects.equals(requestVO.getCbStatus(), StatusEnum.YES.getStatus())) {
                SceneConfigServiceImpl.checkExecuteInterval(requestVO.getCbTriggerType(), requestVO.getCbTriggerInterval());
            }
            groupNameSet.add(requestVO.getGroupName());
            sceneNameSet.add(requestVO.getSceneName());
        }
        this.groupHandler.validateGroupExistence(groupNameSet, namespaceId);
        ConfigAccess sceneConfigAccess = this.accessTemplate.getSceneConfigAccess();
        List sceneConfigs = sceneConfigAccess.list((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{RetrySceneConfig::getSceneName}).eq(RetrySceneConfig::getNamespaceId, (Object)namespaceId)).in(RetrySceneConfig::getGroupName, (Collection)groupNameSet)).in(RetrySceneConfig::getSceneName, (Collection)sceneNameSet));
        Assert.isTrue((boolean)CollUtil.isEmpty((Collection)sceneConfigs), () -> new SnailJobServerException("Import failed. Reason: Scene {} already exists", new Object[]{StreamUtils.toSet((Collection)sceneConfigs, RetrySceneConfig::getSceneName)}));
        LocalDateTime now = LocalDateTime.now();
        List<RetrySceneConfig> retrySceneConfigs = SceneConfigConverter.INSTANCE.toRetrySceneConfigs(requests);
        for (RetrySceneConfig retrySceneConfig : retrySceneConfigs) {
            retrySceneConfig.setCreateDt(now);
            retrySceneConfig.setNamespaceId(namespaceId);
            if (retrySceneConfig.getBackOff().intValue() == WaitStrategies.WaitStrategyEnum.DELAY_LEVEL.getType()) {
                retrySceneConfig.setTriggerInterval("");
            }
            if (Objects.equals(retrySceneConfig.getCbStatus(), StatusEnum.YES.getStatus()) && retrySceneConfig.getCbTriggerType().intValue() == WaitStrategies.WaitStrategyEnum.DELAY_LEVEL.getType()) {
                retrySceneConfig.setCbTriggerInterval("");
            }
            Assert.isTrue((1 == sceneConfigAccess.insert((Object)retrySceneConfig) ? 1 : 0) != 0, () -> new SnailJobServerException("failed to insert scene. retrySceneConfig:[{}]", new Object[]{JsonUtil.toJsonString((Object)retrySceneConfig)}));
        }
    }

    private static void checkExecuteInterval(Integer backOff, String triggerInterval) {
        if (Lists.newArrayList((Object[])new Integer[]{WaitStrategies.WaitStrategyEnum.FIXED.getType(), WaitStrategies.WaitStrategyEnum.RANDOM.getType()}).contains(backOff) ? Integer.parseInt(triggerInterval) < 10 : backOff.intValue() == WaitStrategies.WaitStrategyEnum.CRON.getType() && CronUtils.getExecuteInterval((String)triggerInterval) < 10000L) {
            throw new SnailJobServerException("Interval time must not be less than 10");
        }
    }

    @Generated
    public SceneConfigServiceImpl(AccessTemplate accessTemplate, GroupHandler groupHandler, RetrySummaryMapper retrySummaryMapper) {
        this.accessTemplate = accessTemplate;
        this.groupHandler = groupHandler;
        this.retrySummaryMapper = retrySummaryMapper;
    }

    private static class SceneConfigPartitionTask
    extends PartitionTask {
        private final RetrySceneConfig config;

        public SceneConfigPartitionTask(@NotNull RetrySceneConfig config) {
            this.config = config;
            this.setId(config.getId());
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SceneConfigPartitionTask)) {
                return false;
            }
            SceneConfigPartitionTask other = (SceneConfigPartitionTask)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RetrySceneConfig this$config = this.getConfig();
            RetrySceneConfig other$config = other.getConfig();
            return !(this$config == null ? other$config != null : !this$config.equals(other$config));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SceneConfigPartitionTask;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            RetrySceneConfig $config = this.getConfig();
            result = result * 59 + ($config == null ? 43 : $config.hashCode());
            return result;
        }

        @Generated
        public RetrySceneConfig getConfig() {
            return this.config;
        }
    }
}

