/*
 * Decompiled with CFR 0.152.
 */
package com.aizuda.snailjob.server.web.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.HashUtil;
import cn.hutool.core.util.StrUtil;
import com.aizuda.snailjob.common.core.constant.SystemConstants;
import com.aizuda.snailjob.common.core.enums.StatusEnum;
import com.aizuda.snailjob.common.core.expression.ExpressionEngine;
import com.aizuda.snailjob.common.core.expression.ExpressionFactory;
import com.aizuda.snailjob.common.core.util.JsonUtil;
import com.aizuda.snailjob.common.core.util.StreamUtils;
import com.aizuda.snailjob.common.log.SnailJobLog;
import com.aizuda.snailjob.server.common.WaitStrategy;
import com.aizuda.snailjob.server.common.config.SystemProperties;
import com.aizuda.snailjob.server.common.convert.WorkflowConverter;
import com.aizuda.snailjob.server.common.dto.JobTaskConfig;
import com.aizuda.snailjob.server.common.dto.PartitionTask;
import com.aizuda.snailjob.server.common.enums.ExpressionTypeEnum;
import com.aizuda.snailjob.server.common.enums.JobTaskExecutorSceneEnum;
import com.aizuda.snailjob.server.common.enums.SyetemTaskTypeEnum;
import com.aizuda.snailjob.server.common.exception.SnailJobServerException;
import com.aizuda.snailjob.server.common.handler.WorkflowHandler;
import com.aizuda.snailjob.server.common.strategy.WaitStrategies;
import com.aizuda.snailjob.server.common.util.CronUtils;
import com.aizuda.snailjob.server.common.util.DateUtils;
import com.aizuda.snailjob.server.common.util.GraphUtils;
import com.aizuda.snailjob.server.common.util.PartitionTaskUtils;
import com.aizuda.snailjob.server.common.vo.WorkflowDetailResponseVO;
import com.aizuda.snailjob.server.common.vo.WorkflowResponseVO;
import com.aizuda.snailjob.server.common.vo.request.WorkflowRequestVO;
import com.aizuda.snailjob.server.job.task.dto.WorkflowTaskPrepareDTO;
import com.aizuda.snailjob.server.job.task.support.WorkflowPrePareHandler;
import com.aizuda.snailjob.server.job.task.support.WorkflowTaskConverter;
import com.aizuda.snailjob.server.job.task.support.expression.ExpressionInvocationHandler;
import com.aizuda.snailjob.server.web.model.base.PageResult;
import com.aizuda.snailjob.server.web.model.request.CheckDecisionVO;
import com.aizuda.snailjob.server.web.model.request.ExportWorkflowVO;
import com.aizuda.snailjob.server.web.model.request.UserSessionVO;
import com.aizuda.snailjob.server.web.model.request.WorkflowQueryVO;
import com.aizuda.snailjob.server.web.model.request.WorkflowTriggerVO;
import com.aizuda.snailjob.server.web.service.WorkflowService;
import com.aizuda.snailjob.server.web.service.handler.GroupHandler;
import com.aizuda.snailjob.server.web.util.UserSessionUtils;
import com.aizuda.snailjob.template.datasource.access.AccessTemplate;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.JobSummaryMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowMapper;
import com.aizuda.snailjob.template.datasource.persistence.mapper.WorkflowNodeMapper;
import com.aizuda.snailjob.template.datasource.persistence.po.GroupConfig;
import com.aizuda.snailjob.template.datasource.persistence.po.Job;
import com.aizuda.snailjob.template.datasource.persistence.po.JobSummary;
import com.aizuda.snailjob.template.datasource.persistence.po.Workflow;
import com.aizuda.snailjob.template.datasource.persistence.po.WorkflowNode;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.PageDTO;
import com.google.common.collect.Lists;
import com.google.common.graph.ElementOrder;
import com.google.common.graph.GraphBuilder;
import com.google.common.graph.MutableGraph;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.stream.Collectors;
import lombok.Generated;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Service
@Validated
public class WorkflowServiceImpl
implements WorkflowService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WorkflowServiceImpl.class);
    private final WorkflowMapper workflowMapper;
    private final WorkflowNodeMapper workflowNodeMapper;
    private final SystemProperties systemProperties;
    private final WorkflowHandler workflowHandler;
    private final WorkflowPrePareHandler terminalWorkflowPrepareHandler;
    private final JobMapper jobMapper;
    private final AccessTemplate accessTemplate;
    private final GroupHandler groupHandler;
    private final JobSummaryMapper jobSummaryMapper;

    private static Long calculateNextTriggerAt(WorkflowRequestVO workflowRequestVO, Long time) {
        WorkflowServiceImpl.checkExecuteInterval(workflowRequestVO);
        WaitStrategy waitStrategy = WaitStrategies.WaitStrategyEnum.getWaitStrategy((int)workflowRequestVO.getTriggerType());
        WaitStrategies.WaitStrategyContext waitStrategyContext = new WaitStrategies.WaitStrategyContext();
        waitStrategyContext.setTriggerInterval(workflowRequestVO.getTriggerInterval());
        waitStrategyContext.setNextTriggerAt(time.longValue());
        return waitStrategy.computeTriggerTime(waitStrategyContext);
    }

    private static void checkExecuteInterval(WorkflowRequestVO requestVO) {
        if (Lists.newArrayList((Object[])new Integer[]{WaitStrategies.WaitStrategyEnum.FIXED.getType(), WaitStrategies.WaitStrategyEnum.RANDOM.getType()}).contains(requestVO.getTriggerType()) ? Integer.parseInt(requestVO.getTriggerInterval()) < 10 : requestVO.getTriggerType().intValue() == WaitStrategies.WaitStrategyEnum.CRON.getType() && CronUtils.getExecuteInterval((String)requestVO.getTriggerInterval()) < 10000L) {
            throw new SnailJobServerException("Trigger interval must not be less than 10");
        }
    }

    @Override
    @Transactional
    public boolean saveWorkflow(WorkflowRequestVO workflowRequestVO) {
        log.info("Saved workflow information: {}", (Object)JsonUtil.toJsonString((Object)workflowRequestVO));
        MutableGraph<Long> graph = this.createGraph();
        graph.addNode((Object)SystemConstants.ROOT);
        Workflow workflow = WorkflowConverter.INSTANCE.convert(workflowRequestVO);
        workflow.setVersion(Integer.valueOf(1));
        workflow.setNextTriggerAt(WorkflowServiceImpl.calculateNextTriggerAt(workflowRequestVO, DateUtils.toNowMilli()));
        workflow.setFlowInfo("");
        workflow.setBucketIndex(Integer.valueOf(HashUtil.bkdrHash((String)(workflowRequestVO.getGroupName() + workflowRequestVO.getWorkflowName())) % this.systemProperties.getBucketTotal()));
        workflow.setNamespaceId(UserSessionUtils.currentUserSession().getNamespaceId());
        workflow.setId(null);
        Assert.isTrue((1 == this.workflowMapper.insert((Object)workflow) ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to add workflow"));
        WorkflowRequestVO.NodeConfig nodeConfig = workflowRequestVO.getNodeConfig();
        this.workflowHandler.buildGraph((List)Lists.newArrayList((Object[])new Long[]{SystemConstants.ROOT}), new LinkedBlockingDeque(), workflowRequestVO.getGroupName(), workflow.getId(), nodeConfig, graph, workflow.getVersion());
        log.info("Graph construction complete. graph:[{}]", graph);
        workflow.setVersion(null);
        workflow.setFlowInfo(JsonUtil.toJsonString((Object)GraphUtils.serializeGraphToJson(graph)));
        Assert.isTrue((1 == this.workflowMapper.updateById((Object)workflow) ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to save workflow graph"));
        return true;
    }

    private MutableGraph<Long> createGraph() {
        return GraphBuilder.directed().nodeOrder(ElementOrder.sorted(Long::compare)).incidentEdgeOrder(ElementOrder.stable()).allowsSelfLoops(false).build();
    }

    @Override
    public WorkflowDetailResponseVO getWorkflowDetail(Long id) {
        Workflow workflow = (Workflow)this.workflowMapper.selectOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Workflow::getId, (Object)id)).eq(Workflow::getNamespaceId, (Object)UserSessionUtils.currentUserSession().getNamespaceId()));
        if (Objects.isNull(workflow)) {
            return null;
        }
        return this.doGetWorkflowDetail(workflow);
    }

    @Override
    public PageResult<List<WorkflowResponseVO>> listPage(WorkflowQueryVO queryVO) {
        PageDTO pageDTO = new PageDTO((long)queryVO.getPage(), (long)queryVO.getSize());
        UserSessionVO userSessionVO = UserSessionUtils.currentUserSession();
        List<String> groupNames = UserSessionUtils.getGroupNames(queryVO.getGroupName());
        PageDTO page = (PageDTO)this.workflowMapper.selectPage((IPage)pageDTO, (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Workflow::getDeleted, (Object)StatusEnum.NO.getStatus())).eq(Workflow::getNamespaceId, (Object)userSessionVO.getNamespaceId())).in(CollUtil.isNotEmpty(groupNames), Workflow::getGroupName, groupNames)).like(StrUtil.isNotBlank((CharSequence)queryVO.getWorkflowName()), Workflow::getWorkflowName, (Object)queryVO.getWorkflowName())).eq(Objects.nonNull(queryVO.getWorkflowStatus()), Workflow::getWorkflowStatus, (Object)queryVO.getWorkflowStatus())).orderByDesc(Workflow::getId));
        List jobResponseList = WorkflowConverter.INSTANCE.convertListToWorkflowList(page.getRecords());
        return new PageResult<List<WorkflowResponseVO>>(pageDTO, jobResponseList);
    }

    @Override
    @Transactional
    public Boolean updateWorkflow(WorkflowRequestVO workflowRequestVO) {
        Assert.notNull((Object)workflowRequestVO.getId(), () -> new SnailJobServerException("Workflow ID cannot be null"));
        Workflow workflow = (Workflow)this.workflowMapper.selectById((Serializable)workflowRequestVO.getId());
        Assert.notNull((Object)workflow, () -> new SnailJobServerException("Workflow does not exist"));
        MutableGraph<Long> graph = this.createGraph();
        graph.addNode((Object)SystemConstants.ROOT);
        WorkflowRequestVO.NodeConfig nodeConfig = workflowRequestVO.getNodeConfig();
        int version = workflow.getVersion();
        this.workflowHandler.buildGraph((List)Lists.newArrayList((Object[])new Long[]{SystemConstants.ROOT}), new LinkedBlockingDeque(), workflowRequestVO.getGroupName(), workflowRequestVO.getId(), nodeConfig, graph, Integer.valueOf(version + 1));
        log.info("Graph construction complete. graph:[{}]", graph);
        workflow = WorkflowConverter.INSTANCE.convert(workflowRequestVO);
        workflow.setId(workflowRequestVO.getId());
        workflow.setVersion(Integer.valueOf(version));
        workflow.setNextTriggerAt(WorkflowServiceImpl.calculateNextTriggerAt(workflowRequestVO, DateUtils.toNowMilli()));
        workflow.setFlowInfo(JsonUtil.toJsonString((Object)GraphUtils.serializeGraphToJson(graph)));
        workflow.setGroupName(null);
        Assert.isTrue((this.workflowMapper.update((Object)workflow, (Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Workflow::getId, (Object)workflow.getId())).eq(Workflow::getVersion, (Object)version)) > 0 ? 1 : 0) != 0, () -> new SnailJobServerException("Update failed"));
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateStatus(Long id) {
        Workflow workflow = (Workflow)this.workflowMapper.selectOne((Wrapper)new LambdaQueryWrapper().select(new SFunction[]{Workflow::getId, Workflow::getWorkflowStatus}).eq(Workflow::getId, (Object)id));
        Assert.notNull((Object)workflow, () -> new SnailJobServerException("Workflow does not exist"));
        if (Objects.equals(workflow.getWorkflowStatus(), StatusEnum.NO.getStatus())) {
            workflow.setWorkflowStatus(StatusEnum.YES.getStatus());
        } else {
            workflow.setWorkflowStatus(StatusEnum.NO.getStatus());
        }
        return 1 == this.workflowMapper.updateById((Object)workflow);
    }

    @Override
    public Boolean trigger(WorkflowTriggerVO triggerVO) {
        Workflow workflow = (Workflow)this.workflowMapper.selectById((Serializable)triggerVO.getWorkflowId());
        Assert.notNull((Object)workflow, () -> new SnailJobServerException("workflow can not be null."));
        long count = this.accessTemplate.getGroupConfigAccess().count((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(GroupConfig::getGroupName, (Object)workflow.getGroupName())).eq(GroupConfig::getNamespaceId, (Object)workflow.getNamespaceId())).eq(GroupConfig::getGroupStatus, (Object)StatusEnum.YES.getStatus()));
        Assert.isTrue((count > 0L ? 1 : 0) != 0, () -> new SnailJobServerException("Group [{}] is closed, manual execution is not supported.", new Object[]{workflow.getGroupName()}));
        WorkflowTaskPrepareDTO prepareDTO = WorkflowTaskConverter.INSTANCE.toWorkflowTaskPrepareDTO(workflow);
        prepareDTO.setNextTriggerAt(DateUtils.toNowMilli());
        prepareDTO.setTaskExecutorScene(JobTaskExecutorSceneEnum.MANUAL_WORKFLOW.getType());
        String tmpWfContext = triggerVO.getTmpWfContext();
        if (StrUtil.isNotBlank((CharSequence)tmpWfContext) && !JsonUtil.isEmptyJson((String)tmpWfContext)) {
            prepareDTO.setWfContext(tmpWfContext);
        }
        this.terminalWorkflowPrepareHandler.handler(prepareDTO);
        return Boolean.TRUE;
    }

    @Override
    public List<WorkflowResponseVO> getWorkflowNameList(String keywords, Long workflowId, String groupName) {
        PageDTO selectPage = (PageDTO)this.workflowMapper.selectPage((IPage)new PageDTO(1L, 100L), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{Workflow::getId, Workflow::getWorkflowName}).like(StrUtil.isNotBlank((CharSequence)keywords), Workflow::getWorkflowName, (Object)StrUtil.trim((CharSequence)keywords))).eq(Objects.nonNull(workflowId), Workflow::getId, (Object)workflowId)).eq(StrUtil.isNotBlank((CharSequence)groupName), Workflow::getGroupName, (Object)groupName)).eq(Workflow::getDeleted, (Object)StatusEnum.NO.getStatus())).orderByDesc(Workflow::getId));
        return WorkflowConverter.INSTANCE.convertListToWorkflowList(selectPage.getRecords());
    }

    @Override
    public Pair<Integer, Object> checkNodeExpression(CheckDecisionVO decisionVO) {
        try {
            ExpressionEngine realExpressionEngine = ExpressionTypeEnum.valueOf((Integer)decisionVO.getExpressionType());
            Assert.notNull((Object)realExpressionEngine, () -> new SnailJobServerException("Expression engine does not exist"));
            ExpressionInvocationHandler invocationHandler = new ExpressionInvocationHandler((Object)realExpressionEngine);
            ExpressionEngine expressionEngine = ExpressionFactory.getExpressionEngine((InvocationHandler)invocationHandler);
            Object eval = expressionEngine.eval(decisionVO.getNodeExpression(), new Object[]{decisionVO.getCheckContent()});
            return Pair.of((Object)StatusEnum.YES.getStatus(), (Object)eval);
        }
        catch (Exception e) {
            SnailJobLog.LOCAL.error("Expression exception. [{}]", new Object[]{decisionVO.getNodeExpression(), e});
            return Pair.of((Object)StatusEnum.NO.getStatus(), (Object)e.getMessage());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importWorkflowTask(List<WorkflowRequestVO> requests) {
        this.batchSaveWorkflowTask(requests, UserSessionUtils.currentUserSession().getNamespaceId());
    }

    @Override
    public String exportWorkflowTask(ExportWorkflowVO exportVO) {
        ArrayList resultList = new ArrayList();
        PartitionTaskUtils.process(startId -> {
            List workflowList = ((PageDTO)this.workflowMapper.selectPage((IPage)new PageDTO(0L, 100L, Boolean.FALSE.booleanValue()), (Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Workflow::getNamespaceId, (Object)UserSessionUtils.currentUserSession().getNamespaceId())).eq(Workflow::getDeleted, (Object)StatusEnum.NO.getStatus())).eq(StrUtil.isNotBlank((CharSequence)exportVO.getGroupName()), Workflow::getGroupName, (Object)exportVO.getGroupName())).eq(Objects.nonNull(exportVO.getWorkflowStatus()), Workflow::getWorkflowStatus, (Object)exportVO.getWorkflowStatus())).likeRight(StrUtil.isNotBlank((CharSequence)exportVO.getWorkflowName()), Workflow::getWorkflowName, (Object)exportVO.getWorkflowName())).in(CollUtil.isNotEmpty(exportVO.getWorkflowIds()), Workflow::getId, exportVO.getWorkflowIds())).ge(Workflow::getId, (Object)startId)).orderByAsc(Workflow::getId))).getRecords();
            return workflowList.stream().map(this::doGetWorkflowDetail).map(WorkflowPartitionTask::new).collect(Collectors.toList());
        }, partitionTasks -> {
            List workflowPartitionTasks = partitionTasks;
            resultList.addAll(StreamUtils.toList((Collection)workflowPartitionTasks, WorkflowPartitionTask::getResponseVO));
        }, (long)0L);
        return JsonUtil.toJsonString(resultList);
    }

    @Override
    @Transactional
    public Boolean deleteByIds(Set<Long> ids) {
        String namespaceId = UserSessionUtils.currentUserSession().getNamespaceId();
        Assert.isTrue((ids.size() == this.workflowMapper.delete((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(Workflow::getNamespaceId, (Object)namespaceId)).eq(Workflow::getWorkflowStatus, (Object)StatusEnum.NO.getStatus())).in(Workflow::getId, ids)) ? 1 : 0) != 0, () -> new SnailJobServerException("Failed to delete workflow task, please check if the task status is closed"));
        List jobSummaries = this.jobSummaryMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().select(new SFunction[]{JobSummary::getId}).in(JobSummary::getBusinessId, ids)).eq(JobSummary::getNamespaceId, (Object)namespaceId)).eq(JobSummary::getSystemTaskType, (Object)SyetemTaskTypeEnum.WORKFLOW.getType()));
        if (CollUtil.isNotEmpty((Collection)jobSummaries)) {
            Assert.isTrue((jobSummaries.size() == this.jobSummaryMapper.deleteByIds((Collection)StreamUtils.toSet((Collection)jobSummaries, JobSummary::getId)) ? 1 : 0) != 0, () -> new SnailJobServerException("Summary table deletion failed"));
        }
        return Boolean.TRUE;
    }

    private void batchSaveWorkflowTask(List<WorkflowRequestVO> workflowRequestVOList, String namespaceId) {
        Set groupNameSet = StreamUtils.toSet(workflowRequestVOList, WorkflowRequestVO::getGroupName);
        this.groupHandler.validateGroupExistence(groupNameSet, namespaceId);
        for (WorkflowRequestVO workflowRequestVO : workflowRequestVOList) {
            WorkflowServiceImpl.checkExecuteInterval(workflowRequestVO);
            workflowRequestVO.setId(null);
            this.saveWorkflow(workflowRequestVO);
        }
    }

    private WorkflowDetailResponseVO doGetWorkflowDetail(Workflow workflow) {
        WorkflowDetailResponseVO responseVO = WorkflowConverter.INSTANCE.convert(workflow);
        List workflowNodes = this.workflowNodeMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(WorkflowNode::getDeleted, (Object)0)).eq(WorkflowNode::getVersion, (Object)workflow.getVersion())).eq(WorkflowNode::getWorkflowId, (Object)workflow.getId())).orderByAsc(WorkflowNode::getPriorityLevel));
        List jobIds = StreamUtils.toList((Collection)workflowNodes, WorkflowNode::getJobId);
        List jobs = this.jobMapper.selectList((Wrapper)new LambdaQueryWrapper().in(Job::getId, new HashSet(jobIds)));
        Map jobMap = StreamUtils.toIdentityMap((Collection)jobs, Job::getId);
        List nodeInfos = WorkflowConverter.INSTANCE.convertList(workflowNodes);
        Map<Long, WorkflowDetailResponseVO.NodeInfo> workflowNodeMap = nodeInfos.stream().peek(nodeInfo -> {
            JobTaskConfig jobTask = nodeInfo.getJobTask();
            if (Objects.nonNull(jobTask)) {
                jobTask.setJobName(jobMap.getOrDefault(jobTask.getJobId(), new Job()).getJobName());
            }
        }).collect(Collectors.toMap(WorkflowDetailResponseVO.NodeInfo::getId, i -> i));
        String flowInfo = workflow.getFlowInfo();
        try {
            MutableGraph graph = GraphUtils.deserializeJsonToGraph((String)flowInfo);
            WorkflowDetailResponseVO.NodeConfig config = this.workflowHandler.buildNodeConfig(graph, SystemConstants.ROOT, new HashMap(), workflowNodeMap);
            responseVO.setNodeConfig(config);
        }
        catch (Exception e) {
            log.error("Deserialization failed. json:[{}]", (Object)flowInfo, (Object)e);
            throw new SnailJobServerException("Failed to query workflow details");
        }
        return responseVO;
    }

    @Generated
    public WorkflowServiceImpl(WorkflowMapper workflowMapper, WorkflowNodeMapper workflowNodeMapper, SystemProperties systemProperties, WorkflowHandler workflowHandler, WorkflowPrePareHandler terminalWorkflowPrepareHandler, JobMapper jobMapper, AccessTemplate accessTemplate, GroupHandler groupHandler, JobSummaryMapper jobSummaryMapper) {
        this.workflowMapper = workflowMapper;
        this.workflowNodeMapper = workflowNodeMapper;
        this.systemProperties = systemProperties;
        this.workflowHandler = workflowHandler;
        this.terminalWorkflowPrepareHandler = terminalWorkflowPrepareHandler;
        this.jobMapper = jobMapper;
        this.accessTemplate = accessTemplate;
        this.groupHandler = groupHandler;
        this.jobSummaryMapper = jobSummaryMapper;
    }

    private static class WorkflowPartitionTask
    extends PartitionTask {
        private final WorkflowDetailResponseVO responseVO;

        public WorkflowPartitionTask(@NotNull WorkflowDetailResponseVO responseVO) {
            this.responseVO = responseVO;
            this.setId(responseVO.getId());
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WorkflowPartitionTask)) {
                return false;
            }
            WorkflowPartitionTask other = (WorkflowPartitionTask)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            WorkflowDetailResponseVO this$responseVO = this.getResponseVO();
            WorkflowDetailResponseVO other$responseVO = other.getResponseVO();
            return !(this$responseVO == null ? other$responseVO != null : !this$responseVO.equals(other$responseVO));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof WorkflowPartitionTask;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            WorkflowDetailResponseVO $responseVO = this.getResponseVO();
            result = result * 59 + ($responseVO == null ? 43 : $responseVO.hashCode());
            return result;
        }

        @Generated
        public WorkflowDetailResponseVO getResponseVO() {
            return this.responseVO;
        }
    }
}

