/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.common.thread;

import com.alipay.sofa.common.thread.ThreadPoolConfig;
import com.alipay.sofa.common.thread.ThreadPoolGovernor;
import com.alipay.sofa.common.thread.ThreadPoolMonitorRunner;
import com.alipay.sofa.common.thread.ThreadPoolStatistics;
import com.alipay.sofa.common.thread.log.ThreadLogger;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;

public class ThreadPoolMonitorWrapper {
    private final ThreadPoolExecutor threadPoolExecutor;
    private final ThreadPoolConfig threadPoolConfig;
    private final ThreadPoolStatistics threadPoolStatistics;
    private ScheduledFuture<?> scheduledFuture;

    public ThreadPoolMonitorWrapper(ThreadPoolExecutor threadPoolExecutor, ThreadPoolConfig threadPoolConfig, ThreadPoolStatistics threadPoolStatistics) {
        this.threadPoolExecutor = threadPoolExecutor;
        this.threadPoolConfig = threadPoolConfig;
        this.threadPoolStatistics = threadPoolStatistics;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startMonitor() {
        if (Boolean.FALSE.toString().equals(System.getProperty("sofa_thread_pool_logging_capability"))) {
            return;
        }
        ThreadPoolMonitorWrapper threadPoolMonitorWrapper = this;
        synchronized (threadPoolMonitorWrapper) {
            if (this.scheduledFuture != null) {
                ThreadLogger.warn("Thread pool '{}' is already started with period: {} {}", new Object[]{this.threadPoolConfig.getIdentity(), this.threadPoolConfig.getPeriod(), this.threadPoolConfig.getTimeUnit()});
            } else {
                this.scheduledFuture = ThreadPoolGovernor.getInstance().getMonitorScheduler().scheduleAtFixedRate(new ThreadPoolMonitorRunner(this.threadPoolConfig, this.threadPoolStatistics), this.threadPoolConfig.getPeriod(), this.threadPoolConfig.getPeriod(), this.threadPoolConfig.getTimeUnit());
                ThreadLogger.info("Thread pool '{}' started with period: {} {}", new Object[]{this.threadPoolConfig.getIdentity(), this.threadPoolConfig.getPeriod(), this.threadPoolConfig.getTimeUnit()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopMonitor() {
        ThreadPoolMonitorWrapper threadPoolMonitorWrapper = this;
        synchronized (threadPoolMonitorWrapper) {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(true);
                this.scheduledFuture = null;
                ThreadLogger.info("Thread pool '{}' stopped.", this.threadPoolConfig.getIdentity());
            } else {
                ThreadLogger.warn("Thread pool '{}' is not scheduling!", this.threadPoolConfig.getIdentity());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restartMonitor() {
        ThreadPoolMonitorWrapper threadPoolMonitorWrapper = this;
        synchronized (threadPoolMonitorWrapper) {
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(true);
            }
            this.scheduledFuture = ThreadPoolGovernor.getInstance().getMonitorScheduler().scheduleAtFixedRate(new ThreadPoolMonitorRunner(this.threadPoolConfig, this.threadPoolStatistics), this.threadPoolConfig.getPeriod(), this.threadPoolConfig.getPeriod(), this.threadPoolConfig.getTimeUnit());
            ThreadLogger.info("Restart thread pool '{}' with period: {} {}", new Object[]{this.threadPoolConfig.getIdentity(), this.threadPoolConfig.getPeriod(), this.threadPoolConfig.getTimeUnit()});
        }
    }

    public ThreadPoolExecutor getThreadPoolExecutor() {
        return this.threadPoolExecutor;
    }

    public ThreadPoolConfig getThreadPoolConfig() {
        return this.threadPoolConfig;
    }

    public boolean isStarted() {
        return this.scheduledFuture != null;
    }
}

