/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.async;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.PriorityOrdered;

public class AsyncInitMethodManager
implements PriorityOrdered,
ApplicationListener<ContextRefreshedEvent>,
ApplicationContextAware {
    public static final String ASYNC_INIT_METHOD_EXECUTOR_BEAN_NAME = "async-init-method-executor";
    public static final String ASYNC_INIT_METHOD_NAME = "async-init-method-name";
    private final AtomicReference<ExecutorService> executorServiceRef = new AtomicReference();
    private final Map<BeanFactory, Map<String, String>> asyncInitBeanNameMap = new ConcurrentHashMap<BeanFactory, Map<String, String>>();
    private final List<Future<?>> futures = new ArrayList();
    private ApplicationContext applicationContext;
    private boolean startUpFinish = false;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (this.applicationContext.equals(event.getApplicationContext())) {
            this.ensureAsyncTasksFinish();
        }
    }

    public int getOrder() {
        return -2147483647;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void submitTask(Runnable runnable) {
        ExecutorService executorService;
        boolean success;
        if (this.executorServiceRef.get() == null && !(success = this.executorServiceRef.compareAndSet(null, executorService = this.createAsyncExecutorService()))) {
            executorService.shutdown();
        }
        Future<?> future = this.executorServiceRef.get().submit(runnable);
        this.futures.add(future);
    }

    private ExecutorService createAsyncExecutorService() {
        return (ExecutorService)((Supplier)this.applicationContext.getBean(ASYNC_INIT_METHOD_EXECUTOR_BEAN_NAME, Supplier.class)).get();
    }

    void ensureAsyncTasksFinish() {
        for (Future<?> future : this.futures) {
            try {
                future.get();
            }
            catch (Throwable e) {
                throw new RuntimeException("Async init task finish fail", e);
            }
        }
        this.startUpFinish = true;
        this.futures.clear();
        this.asyncInitBeanNameMap.clear();
        if (this.executorServiceRef.get() != null) {
            this.executorServiceRef.get().shutdown();
            this.executorServiceRef.set(null);
        }
    }

    public boolean isStartUpFinish() {
        return this.startUpFinish;
    }

    public void registerAsyncInitBean(ConfigurableListableBeanFactory beanFactory, String beanName, String asyncInitMethodName) {
        Map map = this.asyncInitBeanNameMap.computeIfAbsent((BeanFactory)beanFactory, k -> new ConcurrentHashMap());
        map.put(beanName, asyncInitMethodName);
    }

    public String findAsyncInitMethod(ConfigurableListableBeanFactory beanFactory, String beanName) {
        Map<String, String> map = this.asyncInitBeanNameMap.get(beanFactory);
        if (map == null) {
            return null;
        }
        return map.get(beanName);
    }
}

