/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.ext.spring.parser;

import com.alipay.sofa.boot.spring.namespace.spi.SofaBootTagNameSupport;
import com.alipay.sofa.runtime.ext.spring.ClassLoaderWrapper;
import com.alipay.sofa.runtime.ext.spring.parser.AbstractSingleExtPointBeanDefinitionParser;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.core.Conventions;
import org.springframework.core.io.Resource;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public abstract class AbstractExtBeanDefinitionParser
extends AbstractSingleExtPointBeanDefinitionParser
implements SofaBootTagNameSupport {
    public static final String REF = "ref";
    private static final String BEAN_CLASS_LOADER_WRAPPER = "beanClassLoaderWrapper";

    @Override
    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        Resource res = parserContext.getReaderContext().getResource();
        builder.getBeanDefinition().setResource(res);
        builder.getRawBeanDefinition().setResource(res);
        this.configBeanClassLoader(parserContext, builder);
        this.parseAttribute(element, parserContext, builder);
        this.parserSubElement(element, parserContext, builder);
    }

    protected void configBeanClassLoader(ParserContext parserContext, BeanDefinitionBuilder builder) {
        ClassLoader beanClassLoader = parserContext.getReaderContext().getBeanClassLoader();
        builder.addPropertyValue(BEAN_CLASS_LOADER_WRAPPER, (Object)new ClassLoaderWrapper(beanClassLoader));
    }

    protected void parseAttribute(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        this.parseCustomAttributes(element, parserContext, builder, (parent, attribute, builder1, parserContext1) -> {
            String name = attribute.getLocalName();
            if (!REF.equals(name)) {
                builder1.addPropertyValue(Conventions.attributeNameToPropertyName((String)name), (Object)attribute.getValue());
            }
        });
    }

    protected abstract void parserSubElement(Element var1, ParserContext var2, BeanDefinitionBuilder var3);

    @Override
    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    protected void parseCustomAttributes(Element element, ParserContext parserContext, BeanDefinitionBuilder builder, AttributeCallback callback) {
        NamedNodeMap attributes = element.getAttributes();
        for (int x = 0; x < attributes.getLength(); ++x) {
            Attr attribute = (Attr)attributes.item(x);
            String name = attribute.getLocalName();
            if ("depends-on".equals(name)) {
                builder.getBeanDefinition().setDependsOn(StringUtils.tokenizeToStringArray((String)attribute.getValue(), (String)",; "));
                continue;
            }
            if ("lazy-init".equals(name)) {
                builder.setLazyInit(Boolean.parseBoolean(attribute.getValue()));
                continue;
            }
            if ("abstract".equals(name)) {
                builder.setAbstract(Boolean.parseBoolean(attribute.getValue()));
                continue;
            }
            if ("parent".equals(name)) {
                builder.setParentName(attribute.getValue());
                continue;
            }
            callback.process(element, attribute, builder, parserContext);
        }
    }

    public static interface AttributeCallback {
        public void process(Element var1, Attr var2, BeanDefinitionBuilder var3, ParserContext var4);
    }
}

