/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.runtime.service.binding;

import com.alipay.sofa.boot.log.ErrorCode;
import com.alipay.sofa.boot.log.SofaBootLoggerFactory;
import com.alipay.sofa.runtime.filter.JvmFilterContext;
import com.alipay.sofa.runtime.filter.JvmFilterHolder;
import com.alipay.sofa.runtime.service.binding.JvmBinding;
import com.alipay.sofa.runtime.service.binding.JvmServiceSupport;
import com.alipay.sofa.runtime.service.component.ServiceComponent;
import com.alipay.sofa.runtime.spi.binding.Contract;
import com.alipay.sofa.runtime.spi.component.SofaRuntimeContext;
import com.alipay.sofa.runtime.spi.service.ServiceProxy;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;

public class JvmServiceInvoker
extends ServiceProxy {
    private static final Logger LOGGER = SofaBootLoggerFactory.getLogger(JvmServiceInvoker.class);
    private final Contract contract;
    private final JvmBinding binding;
    private final SofaRuntimeContext sofaRuntimeContext;
    private Object target;

    public JvmServiceInvoker(Contract contract, JvmBinding binding, SofaRuntimeContext sofaRuntimeContext) {
        super(sofaRuntimeContext.getAppClassLoader());
        this.binding = binding;
        this.sofaRuntimeContext = sofaRuntimeContext;
        this.contract = contract;
    }

    @Override
    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object rtn;
        if (!this.sofaRuntimeContext.getProperties().isJvmFilterEnable()) {
            return super.invoke(invocation);
        }
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        JvmFilterContext context = new JvmFilterContext(invocation);
        if (this.getTarget() == null) {
            ServiceComponent serviceComponent = this.sofaRuntimeContext.getServiceProxyManager().getDynamicServiceComponent(this.contract, this.sofaRuntimeContext.getAppClassLoader());
            if (serviceComponent == null) {
                return super.invoke(invocation);
            }
            context.setSofaRuntimeContext(serviceComponent.getContext());
        } else {
            context.setSofaRuntimeContext(this.sofaRuntimeContext);
        }
        long startTime = System.currentTimeMillis();
        try {
            Thread.currentThread().setContextClassLoader(this.serviceClassLoader);
            if (JvmFilterHolder.beforeInvoking(context)) {
                rtn = this.doInvoke(invocation);
                context.setInvokeResult(rtn);
            }
        }
        catch (Throwable e) {
            context.setException(e);
            this.doCatch(invocation, e, startTime);
            throw e;
        }
        finally {
            JvmFilterHolder.afterInvoking(context);
            rtn = context.getInvokeResult();
            this.doFinally(invocation, startTime);
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return rtn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object doInvoke(MethodInvocation invocation) throws Throwable {
        Object retVal;
        ServiceProxy serviceProxy;
        if (this.binding.isDestroyed()) {
            throw new IllegalStateException("Can not call destroyed reference! JVM Reference[" + this.getInterfaceName() + "#" + this.getUniqueId() + "] has already been destroyed.");
        }
        LOGGER.atDebug().log(">> Start in JVM service invoke, the service interface is  - {}.", this.getInterfaceName());
        Object targetObj = this.getTarget();
        if (targetObj == null && (serviceProxy = this.sofaRuntimeContext.getServiceProxyManager().getDynamicServiceProxy(this.contract, this.sofaRuntimeContext.getAppClassLoader())) != null) {
            try {
                Object object = serviceProxy.invoke(invocation);
                return object;
            }
            finally {
                LOGGER.atDebug().log("<< Finish Cross App JVM service invoke, the service is  - {}.", (Object)(this.getInterfaceName() + "#" + this.getUniqueId()));
            }
        }
        if (targetObj == null || targetObj instanceof Proxy && this.binding.hasBackupProxy()) {
            targetObj = this.binding.getBackupProxy();
            LOGGER.atDebug().log("<<{}.{} backup proxy invoke.", (Object)this.getInterfaceName().getName(), (Object)invocation.getMethod().getName());
        }
        if (targetObj == null) {
            throw new IllegalStateException(ErrorCode.convert((String)"01-00400", (Object[])new Object[]{this.getInterfaceName(), this.getUniqueId()}));
        }
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        try {
            this.pushThreadContextClassLoader(this.sofaRuntimeContext.getAppClassLoader());
            retVal = invocation.getMethod().invoke(targetObj, invocation.getArguments());
        }
        catch (InvocationTargetException ex) {
            try {
                throw ex.getTargetException();
            }
            catch (Throwable throwable) {
                LOGGER.atDebug().log("<< Finish JVM service invoke, the service implementation is  - {}]", (Object)(this.target == null ? "null" : this.target.getClass().getName()));
                this.popThreadContextClassLoader(tcl);
                throw throwable;
            }
        }
        LOGGER.atDebug().log("<< Finish JVM service invoke, the service implementation is  - {}]", (Object)(this.target == null ? "null" : this.target.getClass().getName()));
        this.popThreadContextClassLoader(tcl);
        return retVal;
    }

    @Override
    protected void doCatch(MethodInvocation invocation, Throwable e, long startTime) {
        LOGGER.atDebug().log(() -> this.getCommonInvocationLog("Exception", invocation, startTime));
    }

    @Override
    protected void doFinally(MethodInvocation invocation, long startTime) {
        LOGGER.atDebug().log(() -> this.getCommonInvocationLog("Finally", invocation, startTime));
    }

    protected Object getTarget() {
        ServiceComponent serviceComponent;
        if (this.target == null && (serviceComponent = JvmServiceSupport.foundServiceComponent(this.sofaRuntimeContext.getComponentManager(), this.contract)) != null) {
            this.target = serviceComponent.getImplementation().getTarget();
        }
        return this.target;
    }

    protected Class<?> getInterfaceName() {
        return this.contract.getInterfaceType();
    }

    protected String getUniqueId() {
        return this.contract.getUniqueId();
    }
}

