/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.boot.Initializer;

import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class SwitchableApplicationContextInitializer
implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    protected static final String CONFIG_KEY_PREFIX = "sofa.boot.switch.initializer.";

    public void initialize(ConfigurableApplicationContext applicationContext) {
        if (this.isEnable(applicationContext)) {
            this.doInitialize(applicationContext);
        }
    }

    protected abstract void doInitialize(ConfigurableApplicationContext var1);

    protected abstract String switchKey();

    protected boolean matchIfMissing() {
        return true;
    }

    protected boolean isEnable(ConfigurableApplicationContext applicationContext) {
        String switchKey = this.switchKey();
        Assert.hasText((String)switchKey, (String)"switch key must has text.");
        String realKey = CONFIG_KEY_PREFIX + switchKey + ".enabled";
        String switchStr = applicationContext.getEnvironment().getProperty(realKey);
        if (StringUtils.hasText((String)switchStr)) {
            return Boolean.parseBoolean(switchStr);
        }
        return this.matchIfMissing();
    }
}

